/**
@file	LMS7002M_parameters.h
@author Lime Microsystems (www.limemicro.com)
@brief 	List of LMS7002M transceiver control parameters
*/

#ifndef LMS7002M_PARAMETERS_H
#define LMS7002M_PARAMETERS_H

#include "typedefs.h"
#include <vector>

struct LMS7Parameter;
extern std::vector<const LMS7Parameter*> LMS7parameterList;

struct LMS7Parameter
{
    LMS7Parameter() : address(0), msb(0), lsb(0), defaultValue(0), name(nullptr), tooltip(nullptr)
    {
    }

    LMS7Parameter(uint16_t address, uint8_t msb, uint8_t lsb, uint16_t defaultValue, const char *name, const char* tooltip)
        : address(address), msb(msb), lsb(lsb), defaultValue(defaultValue), name(name), tooltip(tooltip)
    {
        LMS7parameterList.push_back(this);
    }

    uint16_t address;
    uint8_t msb;
    uint8_t lsb;
    uint16_t defaultValue;
    const char* name;
    const char* tooltip;
    inline bool operator==(const LMS7Parameter& obj)
    {
        if (address == obj.address && msb == obj.msb && lsb == obj.lsb)
            return true;
        return false;
    };
};

extern const struct LMS7Parameter LRST_TX_B;
extern const struct LMS7Parameter MRST_TX_B;
extern const struct LMS7Parameter LRST_TX_A;
extern const struct LMS7Parameter MRST_TX_A;
extern const struct LMS7Parameter LRST_RX_B;
extern const struct LMS7Parameter MRST_RX_B;
extern const struct LMS7Parameter LRST_RX_A;
extern const struct LMS7Parameter MRST_RX_A;
extern const struct LMS7Parameter SRST_RXFIFO;
extern const struct LMS7Parameter SRST_TXFIFO;
extern const struct LMS7Parameter RXEN_B;
extern const struct LMS7Parameter RXEN_A;
extern const struct LMS7Parameter TXEN_B;
extern const struct LMS7Parameter TXEN_A;
extern const struct LMS7Parameter MAC;
extern const struct LMS7Parameter TX_CLK_PE;
extern const struct LMS7Parameter RX_CLK_PE;
extern const struct LMS7Parameter SDA_PE;
extern const struct LMS7Parameter SDA_DS;
extern const struct LMS7Parameter SCL_PE;
extern const struct LMS7Parameter SCL_DS;
extern const struct LMS7Parameter SDIO_DS;
extern const struct LMS7Parameter SDIO_PE;
extern const struct LMS7Parameter SDO_PE;
extern const struct LMS7Parameter SCLK_PE;
extern const struct LMS7Parameter SEN_PE;
extern const struct LMS7Parameter SPIMODE;
extern const struct LMS7Parameter DIQ2_DS;
extern const struct LMS7Parameter DIQ2_PE;
extern const struct LMS7Parameter IQ_SEL_EN_2_PE;
extern const struct LMS7Parameter TXNRX2_PE;
extern const struct LMS7Parameter FCLK2_PE;
extern const struct LMS7Parameter MCLK2_PE;
extern const struct LMS7Parameter DIQ1_DS;
extern const struct LMS7Parameter DIQ1_PE;
extern const struct LMS7Parameter IQ_SEL_EN_1_PE;
extern const struct LMS7Parameter TXNRX1_PE;
extern const struct LMS7Parameter FCLK1_PE;
extern const struct LMS7Parameter MCLK1_PE;
extern const struct LMS7Parameter DIQDIRCTR2;
extern const struct LMS7Parameter DIQDIR2;
extern const struct LMS7Parameter DIQDIRCTR1;
extern const struct LMS7Parameter DIQDIR1;
extern const struct LMS7Parameter ENABLEDIRCTR2;
extern const struct LMS7Parameter ENABLEDIR2;
extern const struct LMS7Parameter ENABLEDIRCTR1;
extern const struct LMS7Parameter ENABLEDIR1;
extern const struct LMS7Parameter MOD_EN;
extern const struct LMS7Parameter LML2_FIDM;
extern const struct LMS7Parameter LML2_TXNRXIQ;
extern const struct LMS7Parameter LML2_MODE;
extern const struct LMS7Parameter LML1_FIDM;
extern const struct LMS7Parameter LML1_TXNRXIQ;
extern const struct LMS7Parameter LML1_MODE;
extern const struct LMS7Parameter LML1_S3S;
extern const struct LMS7Parameter LML1_S2S;
extern const struct LMS7Parameter LML1_S1S;
extern const struct LMS7Parameter LML1_S0S;
extern const struct LMS7Parameter LML1_BQP;
extern const struct LMS7Parameter LML1_BIP;
extern const struct LMS7Parameter LML1_AQP;
extern const struct LMS7Parameter LML1_AIP;
extern const struct LMS7Parameter LML1_BB2RF_PST;
extern const struct LMS7Parameter LML1_BB2RF_PRE;
extern const struct LMS7Parameter LML1_RF2BB_PST;
extern const struct LMS7Parameter LML1_RF2BB_PRE;
extern const struct LMS7Parameter LML2_S3S;
extern const struct LMS7Parameter LML2_S2S;
extern const struct LMS7Parameter LML2_S1S;
extern const struct LMS7Parameter LML2_S0S;
extern const struct LMS7Parameter LML2_BQP;
extern const struct LMS7Parameter LML2_BIP;
extern const struct LMS7Parameter LML2_AQP;
extern const struct LMS7Parameter LML2_AIP;
extern const struct LMS7Parameter LML2_BB2RF_PST;
extern const struct LMS7Parameter LML2_BB2RF_PRE;
extern const struct LMS7Parameter LML2_RF2BB_PST;
extern const struct LMS7Parameter LML2_RF2BB_PRE;
extern const struct LMS7Parameter FCLK2_DLY;
extern const struct LMS7Parameter FCLK1_DLY;
extern const struct LMS7Parameter RX_MUX;
extern const struct LMS7Parameter TX_MUX;
extern const struct LMS7Parameter TXRDCLK_MUX;
extern const struct LMS7Parameter TXWRCLK_MUX;
extern const struct LMS7Parameter RXRDCLK_MUX;
extern const struct LMS7Parameter RXWRCLK_MUX;
extern const struct LMS7Parameter FCLK2_INV;
extern const struct LMS7Parameter FCLK1_INV;
extern const struct LMS7Parameter MCLK2DLY;
extern const struct LMS7Parameter MCLK1DLY;
extern const struct LMS7Parameter MCLK2SRC;
extern const struct LMS7Parameter MCLK1SRC;
extern const struct LMS7Parameter TXDIVEN;
extern const struct LMS7Parameter RXDIVEN;
extern const struct LMS7Parameter TXTSPCLKA_DIV;
extern const struct LMS7Parameter RXTSPCLKA_DIV;
extern const struct LMS7Parameter MIMO_SISO;
extern const struct LMS7Parameter VER;
extern const struct LMS7Parameter REV;
extern const struct LMS7Parameter MASK;
extern const struct LMS7Parameter EN_DIR_LDO;
extern const struct LMS7Parameter EN_DIR_CGEN;
extern const struct LMS7Parameter EN_DIR_XBUF;
extern const struct LMS7Parameter EN_DIR_AFE;
extern const struct LMS7Parameter ISEL_DAC_AFE;
extern const struct LMS7Parameter MODE_INTERLEAVE_AFE;
extern const struct LMS7Parameter MUX_AFE_1;
extern const struct LMS7Parameter MUX_AFE_2;
extern const struct LMS7Parameter PD_AFE;
extern const struct LMS7Parameter PD_RX_AFE1;
extern const struct LMS7Parameter PD_RX_AFE2;
extern const struct LMS7Parameter PD_TX_AFE1;
extern const struct LMS7Parameter PD_TX_AFE2;
extern const struct LMS7Parameter EN_G_AFE;
extern const struct LMS7Parameter MUX_BIAS_OUT;
extern const struct LMS7Parameter RP_CALIB_BIAS;
extern const struct LMS7Parameter PD_FRP_BIAS;
extern const struct LMS7Parameter PD_F_BIAS;
extern const struct LMS7Parameter PD_PTRP_BIAS;
extern const struct LMS7Parameter PD_PT_BIAS;
extern const struct LMS7Parameter PD_BIAS_MASTER;
extern const struct LMS7Parameter SLFB_XBUF_RX;
extern const struct LMS7Parameter SLFB_XBUF_TX;
extern const struct LMS7Parameter BYP_XBUF_RX;
extern const struct LMS7Parameter BYP_XBUF_TX;
extern const struct LMS7Parameter EN_OUT2_XBUF_TX;
extern const struct LMS7Parameter EN_TBUFIN_XBUF_RX;
extern const struct LMS7Parameter PD_XBUF_RX;
extern const struct LMS7Parameter PD_XBUF_TX;
extern const struct LMS7Parameter EN_G_XBUF;
extern const struct LMS7Parameter SPDUP_VCO_CGEN;
extern const struct LMS7Parameter RESET_N_CGEN;
extern const struct LMS7Parameter EN_ADCCLKH_CLKGN;
extern const struct LMS7Parameter EN_COARSE_CKLGEN;
extern const struct LMS7Parameter EN_INTONLY_SDM_CGEN;
extern const struct LMS7Parameter EN_SDM_CLK_CGEN;
extern const struct LMS7Parameter PD_CP_CGEN;
extern const struct LMS7Parameter PD_FDIV_FB_CGEN;
extern const struct LMS7Parameter PD_FDIV_O_CGEN;
extern const struct LMS7Parameter PD_SDM_CGEN;
extern const struct LMS7Parameter PD_VCO_CGEN;
extern const struct LMS7Parameter PD_VCO_COMP_CGEN;
extern const struct LMS7Parameter EN_G_CGEN;
extern const struct LMS7Parameter FRAC_SDM_CGEN_LSB;
extern const struct LMS7Parameter INT_SDM_CGEN;
extern const struct LMS7Parameter FRAC_SDM_CGEN_MSB;
extern const struct LMS7Parameter REV_SDMCLK_CGEN;
extern const struct LMS7Parameter SEL_SDMCLK_CGEN;
extern const struct LMS7Parameter SX_DITHER_EN_CGEN;
extern const struct LMS7Parameter CLKH_OV_CLKL_CGEN;
extern const struct LMS7Parameter DIV_OUTCH_CGEN;
extern const struct LMS7Parameter TST_CGEN;
extern const struct LMS7Parameter REV_CLKDAC_CGEN;
extern const struct LMS7Parameter CMPLO_CTRL_CGEN;
extern const struct LMS7Parameter REV_CLKADC_CGEN;
extern const struct LMS7Parameter REVPH_PFD_CGEN;
extern const struct LMS7Parameter IOFFSET_CP_CGEN;
extern const struct LMS7Parameter IPULSE_CP_CGEN;
extern const struct LMS7Parameter ICT_VCO_CGEN;
extern const struct LMS7Parameter CSW_VCO_CGEN;
extern const struct LMS7Parameter COARSE_START_CGEN;
extern const struct LMS7Parameter COARSE_STEPDONE_CGEN;
extern const struct LMS7Parameter COARSEPLL_COMPO_CGEN;
extern const struct LMS7Parameter VCO_CMPHO_CGEN;
extern const struct LMS7Parameter VCO_CMPLO_CGEN;
extern const struct LMS7Parameter CP2_CGEN;
extern const struct LMS7Parameter CP3_CGEN;
extern const struct LMS7Parameter CZ_CGEN;
extern const struct LMS7Parameter EN_LDO_DIG;
extern const struct LMS7Parameter EN_LDO_DIGGN;
extern const struct LMS7Parameter EN_LDO_DIGSXR;
extern const struct LMS7Parameter EN_LDO_DIGSXT;
extern const struct LMS7Parameter EN_LDO_DIVGN;
extern const struct LMS7Parameter EN_LDO_DIVSXR;
extern const struct LMS7Parameter EN_LDO_DIVSXT;
extern const struct LMS7Parameter EN_LDO_LNA12;
extern const struct LMS7Parameter EN_LDO_LNA14;
extern const struct LMS7Parameter EN_LDO_MXRFE;
extern const struct LMS7Parameter EN_LDO_RBB;
extern const struct LMS7Parameter EN_LDO_RXBUF;
extern const struct LMS7Parameter EN_LDO_TBB;
extern const struct LMS7Parameter EN_LDO_TIA12;
extern const struct LMS7Parameter EN_LDO_TIA14;
extern const struct LMS7Parameter EN_G_LDO;
extern const struct LMS7Parameter EN_LOADIMP_LDO_TLOB;
extern const struct LMS7Parameter EN_LOADIMP_LDO_TPAD;
extern const struct LMS7Parameter EN_LOADIMP_LDO_TXBUF;
extern const struct LMS7Parameter EN_LOADIMP_LDO_VCOGN;
extern const struct LMS7Parameter EN_LOADIMP_LDO_VCOSXR;
extern const struct LMS7Parameter EN_LOADIMP_LDO_VCOSXT;
extern const struct LMS7Parameter EN_LDO_AFE;
extern const struct LMS7Parameter EN_LDO_CPGN;
extern const struct LMS7Parameter EN_LDO_CPSXR;
extern const struct LMS7Parameter EN_LDO_TLOB;
extern const struct LMS7Parameter EN_LDO_TPAD;
extern const struct LMS7Parameter EN_LDO_TXBUF;
extern const struct LMS7Parameter EN_LDO_VCOGN;
extern const struct LMS7Parameter EN_LDO_VCOSXR;
extern const struct LMS7Parameter EN_LDO_VCOSXT;
extern const struct LMS7Parameter EN_LDO_CPSXT;
extern const struct LMS7Parameter EN_LOADIMP_LDO_CPSXT;
extern const struct LMS7Parameter EN_LOADIMP_LDO_DIG;
extern const struct LMS7Parameter EN_LOADIMP_LDO_DIGGN;
extern const struct LMS7Parameter EN_LOADIMP_LDO_DIGSXR;
extern const struct LMS7Parameter EN_LOADIMP_LDO_DIGSXT;
extern const struct LMS7Parameter EN_LOADIMP_LDO_DIVGN;
extern const struct LMS7Parameter EN_LOADIMP_LDO_DIVSXR;
extern const struct LMS7Parameter EN_LOADIMP_LDO_DIVSXT;
extern const struct LMS7Parameter EN_LOADIMP_LDO_LNA12;
extern const struct LMS7Parameter EN_LOADIMP_LDO_LNA14;
extern const struct LMS7Parameter EN_LOADIMP_LDO_MXRFE;
extern const struct LMS7Parameter EN_LOADIMP_LDO_RBB;
extern const struct LMS7Parameter EN_LOADIMP_LDO_RXBUF;
extern const struct LMS7Parameter EN_LOADIMP_LDO_TBB;
extern const struct LMS7Parameter EN_LOADIMP_LDO_TIA12;
extern const struct LMS7Parameter EN_LOADIMP_LDO_TIA14;
extern const struct LMS7Parameter BYP_LDO_TBB;
extern const struct LMS7Parameter BYP_LDO_TIA12;
extern const struct LMS7Parameter BYP_LDO_TIA14;
extern const struct LMS7Parameter BYP_LDO_TLOB;
extern const struct LMS7Parameter BYP_LDO_TPAD;
extern const struct LMS7Parameter BYP_LDO_TXBUF;
extern const struct LMS7Parameter BYP_LDO_VCOGN;
extern const struct LMS7Parameter BYP_LDO_VCOSXR;
extern const struct LMS7Parameter BYP_LDO_VCOSXT;
extern const struct LMS7Parameter EN_LOADIMP_LDO_AFE;
extern const struct LMS7Parameter EN_LOADIMP_LDO_CPGN;
extern const struct LMS7Parameter EN_LOADIMP_LDO_CPSXR;
extern const struct LMS7Parameter BYP_LDO_AFE;
extern const struct LMS7Parameter BYP_LDO_CPGN;
extern const struct LMS7Parameter BYP_LDO_CPSXR;
extern const struct LMS7Parameter BYP_LDO_CPSXT;
extern const struct LMS7Parameter BYP_LDO_DIG;
extern const struct LMS7Parameter BYP_LDO_DIGGN;
extern const struct LMS7Parameter BYP_LDO_DIGSXR;
extern const struct LMS7Parameter BYP_LDO_DIGSXT;
extern const struct LMS7Parameter BYP_LDO_DIVGN;
extern const struct LMS7Parameter BYP_LDO_DIVSXR;
extern const struct LMS7Parameter BYP_LDO_DIVSXT;
extern const struct LMS7Parameter BYP_LDO_LNA12;
extern const struct LMS7Parameter BYP_LDO_LNA14;
extern const struct LMS7Parameter BYP_LDO_MXRFE;
extern const struct LMS7Parameter BYP_LDO_RBB;
extern const struct LMS7Parameter BYP_LDO_RXBUF;
extern const struct LMS7Parameter SPDUP_LDO_DIVSXR;
extern const struct LMS7Parameter SPDUP_LDO_DIVSXT;
extern const struct LMS7Parameter SPDUP_LDO_LNA12;
extern const struct LMS7Parameter SPDUP_LDO_LNA14;
extern const struct LMS7Parameter SPDUP_LDO_MXRFE;
extern const struct LMS7Parameter SPDUP_LDO_RBB;
extern const struct LMS7Parameter SPDUP_LDO_RXBUF;
extern const struct LMS7Parameter SPDUP_LDO_TBB;
extern const struct LMS7Parameter SPDUP_LDO_TIA12;
extern const struct LMS7Parameter SPDUP_LDO_TIA14;
extern const struct LMS7Parameter SPDUP_LDO_TLOB;
extern const struct LMS7Parameter SPDUP_LDO_TPAD;
extern const struct LMS7Parameter SPDUP_LDO_TXBUF;
extern const struct LMS7Parameter SPDUP_LDO_VCOGN;
extern const struct LMS7Parameter SPDUP_LDO_VCOSXR;
extern const struct LMS7Parameter SPDUP_LDO_VCOSXT;
extern const struct LMS7Parameter SPDUP_LDO_AFE;
extern const struct LMS7Parameter SPDUP_LDO_CPGN;
extern const struct LMS7Parameter SPDUP_LDO_CPSXR;
extern const struct LMS7Parameter SPDUP_LDO_CPSXT;
extern const struct LMS7Parameter SPDUP_LDO_DIG;
extern const struct LMS7Parameter SPDUP_LDO_DIGGN;
extern const struct LMS7Parameter SPDUP_LDO_DIGSXR;
extern const struct LMS7Parameter SPDUP_LDO_DIGSXT;
extern const struct LMS7Parameter SPDUP_LDO_DIVGN;
extern const struct LMS7Parameter RDIV_VCOSXR;
extern const struct LMS7Parameter RDIV_VCOSXT;
extern const struct LMS7Parameter RDIV_TXBUF;
extern const struct LMS7Parameter RDIV_VCOGN;
extern const struct LMS7Parameter RDIV_TLOB;
extern const struct LMS7Parameter RDIV_TPAD;
extern const struct LMS7Parameter RDIV_TIA12;
extern const struct LMS7Parameter RDIV_TIA14;
extern const struct LMS7Parameter RDIV_RXBUF;
extern const struct LMS7Parameter RDIV_TBB;
extern const struct LMS7Parameter RDIV_MXRFE;
extern const struct LMS7Parameter RDIV_RBB;
extern const struct LMS7Parameter RDIV_LNA12;
extern const struct LMS7Parameter RDIV_LNA14;
extern const struct LMS7Parameter RDIV_DIVSXR;
extern const struct LMS7Parameter RDIV_DIVSXT;
extern const struct LMS7Parameter RDIV_DIGSXT;
extern const struct LMS7Parameter RDIV_DIVGN;
extern const struct LMS7Parameter RDIV_DIGGN;
extern const struct LMS7Parameter RDIV_DIGSXR;
extern const struct LMS7Parameter RDIV_CPSXT;
extern const struct LMS7Parameter RDIV_DIG;
extern const struct LMS7Parameter RDIV_CPGN;
extern const struct LMS7Parameter RDIV_CPSXR;
extern const struct LMS7Parameter RDIV_SPIBUF;
extern const struct LMS7Parameter RDIV_AFE;
extern const struct LMS7Parameter SPDUP_LDO_SPIBUF;
extern const struct LMS7Parameter SPDUP_LDO_DIGIp2;
extern const struct LMS7Parameter SPDUP_LDO_DIGIp1;
extern const struct LMS7Parameter BYP_LDO_SPIBUF;
extern const struct LMS7Parameter BYP_LDO_DIGIp2;
extern const struct LMS7Parameter BYP_LDO_DIGIp1;
extern const struct LMS7Parameter EN_LOADIMP_LDO_SPIBUF;
extern const struct LMS7Parameter EN_LOADIMP_LDO_DIGIp2;
extern const struct LMS7Parameter EN_LOADIMP_LDO_DIGIp1;
extern const struct LMS7Parameter PD_LDO_SPIBUF;
extern const struct LMS7Parameter PD_LDO_DIGIp2;
extern const struct LMS7Parameter PD_LDO_DIGIp1;
extern const struct LMS7Parameter EN_G_LDOP;
extern const struct LMS7Parameter RDIV_DIGIp2;
extern const struct LMS7Parameter RDIV_DIGIp1;
extern const struct LMS7Parameter BSIGT;
extern const struct LMS7Parameter BSTATE;
extern const struct LMS7Parameter EN_SDM_TSTO_SXT;
extern const struct LMS7Parameter EN_SDM_TSTO_SXR;
extern const struct LMS7Parameter EN_SDM_TSTO_CGEN;
extern const struct LMS7Parameter BENC;
extern const struct LMS7Parameter BENR;
extern const struct LMS7Parameter BENT;
extern const struct LMS7Parameter BSTART;
extern const struct LMS7Parameter BSIGR;
extern const struct LMS7Parameter BSIGC;
extern const struct LMS7Parameter CDS_MCLK2;
extern const struct LMS7Parameter CDS_MCLK1;
extern const struct LMS7Parameter CDSN_TXBTSP;
extern const struct LMS7Parameter CDSN_TXATSP;
extern const struct LMS7Parameter CDSN_RXBTSP;
extern const struct LMS7Parameter CDSN_RXATSP;
extern const struct LMS7Parameter CDSN_TXBLML;
extern const struct LMS7Parameter CDSN_TXALML;
extern const struct LMS7Parameter CDSN_RXBLML;
extern const struct LMS7Parameter CDSN_RXALML;
extern const struct LMS7Parameter CDSN_MCLK2;
extern const struct LMS7Parameter CDSN_MCLK1;
extern const struct LMS7Parameter CDS_TXBTSP;
extern const struct LMS7Parameter CDS_TXATSP;
extern const struct LMS7Parameter CDS_RXBTSP;
extern const struct LMS7Parameter CDS_RXATSP;
extern const struct LMS7Parameter CDS_TXBLML;
extern const struct LMS7Parameter CDS_TXALML;
extern const struct LMS7Parameter CDS_RXBLML;
extern const struct LMS7Parameter CDS_RXALML;
extern const struct LMS7Parameter EN_LOWBWLOMX_TMX_TRF;
extern const struct LMS7Parameter EN_NEXTTX_TRF;
extern const struct LMS7Parameter EN_AMPHF_PDET_TRF;
extern const struct LMS7Parameter LOADR_PDET_TRF;
extern const struct LMS7Parameter PD_PDET_TRF;
extern const struct LMS7Parameter PD_TLOBUF_TRF;
extern const struct LMS7Parameter PD_TXPAD_TRF;
extern const struct LMS7Parameter EN_G_TRF;
extern const struct LMS7Parameter F_TXPAD_TRF;
extern const struct LMS7Parameter L_LOOPB_TXPAD_TRF;
extern const struct LMS7Parameter LOSS_LIN_TXPAD_TRF;
extern const struct LMS7Parameter LOSS_MAIN_TXPAD_TRF;
extern const struct LMS7Parameter EN_LOOPB_TXPAD_TRF;
extern const struct LMS7Parameter GCAS_GNDREF_TXPAD_TRF;
extern const struct LMS7Parameter ICT_LIN_TXPAD_TRF;
extern const struct LMS7Parameter ICT_MAIN_TXPAD_TRF;
extern const struct LMS7Parameter VGCAS_TXPAD_TRF;
extern const struct LMS7Parameter SEL_BAND1_TRF;
extern const struct LMS7Parameter SEL_BAND2_TRF;
extern const struct LMS7Parameter LOBIASN_TXM_TRF;
extern const struct LMS7Parameter LOBIASP_TXX_TRF;
extern const struct LMS7Parameter CDC_I_TRF;
extern const struct LMS7Parameter CDC_Q_TRF;
extern const struct LMS7Parameter STATPULSE_TBB;
extern const struct LMS7Parameter LOOPB_TBB;
extern const struct LMS7Parameter PD_LPFH_TBB;
extern const struct LMS7Parameter PD_LPFIAMP_TBB;
extern const struct LMS7Parameter PD_LPFLAD_TBB;
extern const struct LMS7Parameter PD_LPFS5_TBB;
extern const struct LMS7Parameter EN_G_TBB;
extern const struct LMS7Parameter ICT_LPFS5_F_TBB;
extern const struct LMS7Parameter ICT_LPFS5_PT_TBB;
extern const struct LMS7Parameter ICT_LPF_H_PT_TBB;
extern const struct LMS7Parameter ICT_LPFH_F_TBB;
extern const struct LMS7Parameter ICT_LPFLAD_F_TBB;
extern const struct LMS7Parameter ICT_LPFLAD_PT_TBB;
extern const struct LMS7Parameter CG_IAMP_TBB;
extern const struct LMS7Parameter ICT_IAMP_FRP_TBB;
extern const struct LMS7Parameter ICT_IAMP_GG_FRP_TBB;
extern const struct LMS7Parameter RCAL_LPFH_TBB;
extern const struct LMS7Parameter RCAL_LPFLAD_TBB;
extern const struct LMS7Parameter TSTIN_TBB;
extern const struct LMS7Parameter BYPLADDER_TBB;
extern const struct LMS7Parameter CCAL_LPFLAD_TBB;
extern const struct LMS7Parameter RCAL_LPFS5_TBB;
extern const struct LMS7Parameter CDC_I_RFE;
extern const struct LMS7Parameter CDC_Q_RFE;
extern const struct LMS7Parameter PD_LNA_RFE;
extern const struct LMS7Parameter PD_RLOOPB_1_RFE;
extern const struct LMS7Parameter PD_RLOOPB_2_RFE;
extern const struct LMS7Parameter PD_MXLOBUF_RFE;
extern const struct LMS7Parameter PD_QGEN_RFE;
extern const struct LMS7Parameter PD_RSSI_RFE;
extern const struct LMS7Parameter PD_TIA_RFE;
extern const struct LMS7Parameter EN_G_RFE;
extern const struct LMS7Parameter SEL_PATH_RFE;
extern const struct LMS7Parameter EN_DCOFF_RXFE_RFE;
extern const struct LMS7Parameter EN_INSHSW_LB1_RFE;
extern const struct LMS7Parameter EN_INSHSW_LB2_RFE;
extern const struct LMS7Parameter EN_INSHSW_L_RFE;
extern const struct LMS7Parameter EN_INSHSW_W_RFE;
extern const struct LMS7Parameter EN_NEXTRX_RFE;
extern const struct LMS7Parameter DCOFFI_RFE;
extern const struct LMS7Parameter DCOFFQ_RFE;
extern const struct LMS7Parameter ICT_LOOPB_RFE;
extern const struct LMS7Parameter ICT_TIAMAIN_RFE;
extern const struct LMS7Parameter ICT_TIAOUT_RFE;
extern const struct LMS7Parameter ICT_LNACMO_RFE;
extern const struct LMS7Parameter ICT_LNA_RFE;
extern const struct LMS7Parameter ICT_LODC_RFE;
extern const struct LMS7Parameter CAP_RXMXO_RFE;
extern const struct LMS7Parameter CGSIN_LNA_RFE;
extern const struct LMS7Parameter CCOMP_TIA_RFE;
extern const struct LMS7Parameter CFB_TIA_RFE;
extern const struct LMS7Parameter G_LNA_RFE;
extern const struct LMS7Parameter G_RXLOOPB_RFE;
extern const struct LMS7Parameter G_TIA_RFE;
extern const struct LMS7Parameter RCOMP_TIA_RFE;
extern const struct LMS7Parameter RFB_TIA_RFE;
extern const struct LMS7Parameter EN_LB_LPFH_RBB;
extern const struct LMS7Parameter EN_LB_LPFL_RBB;
extern const struct LMS7Parameter PD_LPFH_RBB;
extern const struct LMS7Parameter PD_LPFL_RBB;
extern const struct LMS7Parameter PD_PGA_RBB;
extern const struct LMS7Parameter EN_G_RBB;
extern const struct LMS7Parameter R_CTL_LPF_RBB;
extern const struct LMS7Parameter RCC_CTL_LPFH_RBB;
extern const struct LMS7Parameter C_CTL_LPFH_RBB;
extern const struct LMS7Parameter RCC_CTL_LPFL_RBB;
extern const struct LMS7Parameter C_CTL_LPFL_RBB;
extern const struct LMS7Parameter INPUT_CTL_PGA_RBB;
extern const struct LMS7Parameter ICT_LPF_IN_RBB;
extern const struct LMS7Parameter ICT_LPF_OUT_RBB;
extern const struct LMS7Parameter OSW_PGA_RBB;
extern const struct LMS7Parameter ICT_PGA_OUT_RBB;
extern const struct LMS7Parameter ICT_PGA_IN_RBB;
extern const struct LMS7Parameter G_PGA_RBB;
extern const struct LMS7Parameter RCC_CTL_PGA_RBB;
extern const struct LMS7Parameter C_CTL_PGA_RBB;
extern const struct LMS7Parameter RESET_N;
extern const struct LMS7Parameter SPDUP_VCO;
extern const struct LMS7Parameter BYPLDO_VCO;
extern const struct LMS7Parameter EN_COARSEPLL;
extern const struct LMS7Parameter CURLIM_VCO;
extern const struct LMS7Parameter EN_DIV2_DIVPROG;
extern const struct LMS7Parameter EN_INTONLY_SDM;
extern const struct LMS7Parameter EN_SDM_CLK;
extern const struct LMS7Parameter PD_FBDIV;
extern const struct LMS7Parameter PD_LOCH_T2RBUF;
extern const struct LMS7Parameter PD_CP;
extern const struct LMS7Parameter PD_FDIV;
extern const struct LMS7Parameter PD_SDM;
extern const struct LMS7Parameter PD_VCO_COMP;
extern const struct LMS7Parameter PD_VCO;
extern const struct LMS7Parameter EN_G;
extern const struct LMS7Parameter FRAC_SDM_LSB;
extern const struct LMS7Parameter INT_SDM;
extern const struct LMS7Parameter FRAC_SDM_MSB;
extern const struct LMS7Parameter PW_DIV2_LOCH;
extern const struct LMS7Parameter PW_DIV4_LOCH;
extern const struct LMS7Parameter DIV_LOCH;
extern const struct LMS7Parameter TST_SX;
extern const struct LMS7Parameter SEL_SDMCLK;
extern const struct LMS7Parameter SX_DITHER_EN;
extern const struct LMS7Parameter REV_SDMCLK;
extern const struct LMS7Parameter VDIV_VCO;
extern const struct LMS7Parameter ICT_VCO;
extern const struct LMS7Parameter RSEL_LDO_VCO;
extern const struct LMS7Parameter CSW_VCO;
extern const struct LMS7Parameter SEL_VCO;
extern const struct LMS7Parameter COARSE_START;
extern const struct LMS7Parameter REVPH_PFD;
extern const struct LMS7Parameter IOFFSET_CP;
extern const struct LMS7Parameter IPULSE_CP;
extern const struct LMS7Parameter COARSE_STEPDONE;
extern const struct LMS7Parameter COARSEPLL_COMPO;
extern const struct LMS7Parameter VCO_CMPHO;
extern const struct LMS7Parameter VCO_CMPLO;
extern const struct LMS7Parameter CP2_PLL;
extern const struct LMS7Parameter CP3_PLL;
extern const struct LMS7Parameter CZ;
extern const struct LMS7Parameter EN_DIR_SXRSXT;
extern const struct LMS7Parameter EN_DIR_RBB;
extern const struct LMS7Parameter EN_DIR_RFE;
extern const struct LMS7Parameter EN_DIR_TBB;
extern const struct LMS7Parameter EN_DIR_TRF;
extern const struct LMS7Parameter TSGFC_TXTSP;
extern const struct LMS7Parameter TSGFCW_TXTSP;
extern const struct LMS7Parameter TSGDCLDQ_TXTSP;
extern const struct LMS7Parameter TSGDCLDI_TXTSP;
extern const struct LMS7Parameter TSGSWAPIQ_TXTSP;
extern const struct LMS7Parameter TSGMODE_TXTSP;
extern const struct LMS7Parameter INSEL_TXTSP;
extern const struct LMS7Parameter BSTART_TXTSP;
extern const struct LMS7Parameter EN_TXTSP;
extern const struct LMS7Parameter GCORRQ_TXTSP;
extern const struct LMS7Parameter GCORRI_TXTSP;
extern const struct LMS7Parameter HBI_OVR_TXTSP;
extern const struct LMS7Parameter IQCORR_TXTSP;
extern const struct LMS7Parameter DCCORRI_TXTSP;
extern const struct LMS7Parameter DCCORRQ_TXTSP;
extern const struct LMS7Parameter GFIR1_L_TXTSP;
extern const struct LMS7Parameter GFIR1_N_TXTSP;
extern const struct LMS7Parameter GFIR2_L_TXTSP;
extern const struct LMS7Parameter GFIR2_N_TXTSP;
extern const struct LMS7Parameter GFIR3_L_TXTSP;
extern const struct LMS7Parameter GFIR3_N_TXTSP;
extern const struct LMS7Parameter CMIX_GAIN_TXTSP;
extern const struct LMS7Parameter CMIX_SC_TXTSP;
extern const struct LMS7Parameter CMIX_BYP_TXTSP;
extern const struct LMS7Parameter ISINC_BYP_TXTSP;
extern const struct LMS7Parameter GFIR3_BYP_TXTSP;
extern const struct LMS7Parameter GFIR2_BYP_TXTSP;
extern const struct LMS7Parameter GFIR1_BYP_TXTSP;
extern const struct LMS7Parameter DC_BYP_TXTSP;
extern const struct LMS7Parameter GC_BYP_TXTSP;
extern const struct LMS7Parameter PH_BYP_TXTSP;
extern const struct LMS7Parameter BSIGI_TXTSP;
extern const struct LMS7Parameter BSTATE_TXTSP;
extern const struct LMS7Parameter BSIGQ_TXTSP;
extern const struct LMS7Parameter DC_REG_TXTSP;
extern const struct LMS7Parameter DTHBIT_TX;
extern const struct LMS7Parameter SEL_TX;
extern const struct LMS7Parameter MODE_TX;
extern const struct LMS7Parameter CAPTURE;
extern const struct LMS7Parameter CAPSEL;
extern const struct LMS7Parameter CAPSEL_ADC;
extern const struct LMS7Parameter TSGFC_RXTSP;
extern const struct LMS7Parameter TSGFCW_RXTSP;
extern const struct LMS7Parameter TSGDCLDQ_RXTSP;
extern const struct LMS7Parameter TSGDCLDI_RXTSP;
extern const struct LMS7Parameter TSGSWAPIQ_RXTSP;
extern const struct LMS7Parameter TSGMODE_RXTSP;
extern const struct LMS7Parameter INSEL_RXTSP;
extern const struct LMS7Parameter BSTART_RXTSP;
extern const struct LMS7Parameter EN_RXTSP;
extern const struct LMS7Parameter GCORRQ_RXTSP;
extern const struct LMS7Parameter GCORRI_RXTSP;
extern const struct LMS7Parameter HBD_OVR_RXTSP;
extern const struct LMS7Parameter IQCORR_RXTSP;
extern const struct LMS7Parameter HBD_DLY;
extern const struct LMS7Parameter DCLOOP_BYP;
extern const struct LMS7Parameter DCCORR_AVG_RXTSP;
extern const struct LMS7Parameter GFIR1_L_RXTSP;
extern const struct LMS7Parameter GFIR1_N_RXTSP;
extern const struct LMS7Parameter GFIR2_L_RXTSP;
extern const struct LMS7Parameter GFIR2_N_RXTSP;
extern const struct LMS7Parameter GFIR3_L_RXTSP;
extern const struct LMS7Parameter GFIR3_N_RXTSP;
extern const struct LMS7Parameter AGC_K_RXTSP;
extern const struct LMS7Parameter AGC_ADESIRED_RXTSP;
extern const struct LMS7Parameter RSSI_MODE;
extern const struct LMS7Parameter AGC_MODE_RXTSP;
extern const struct LMS7Parameter AGC_AVG_RXTSP;
extern const struct LMS7Parameter DC_REG_RXTSP;
extern const struct LMS7Parameter CMIX_GAIN_RXTSP;
extern const struct LMS7Parameter CMIX_SC_RXTSP;
extern const struct LMS7Parameter CMIX_BYP_RXTSP;
extern const struct LMS7Parameter AGC_BYP_RXTSP;
extern const struct LMS7Parameter GFIR3_BYP_RXTSP;
extern const struct LMS7Parameter GFIR2_BYP_RXTSP;
extern const struct LMS7Parameter GFIR1_BYP_RXTSP;
extern const struct LMS7Parameter DC_BYP_RXTSP;
extern const struct LMS7Parameter GC_BYP_RXTSP;
extern const struct LMS7Parameter PH_BYP_RXTSP;
extern const struct LMS7Parameter CAPD;
extern const struct LMS7Parameter DTHBIT_RX;
extern const struct LMS7Parameter SEL_RX;
extern const struct LMS7Parameter MODE_RX;

#endif
