#!/bin/bash
#******************************************************************************

#    OpenAirInterface 
#    Copyright(c) 1999 - 2014 Eurecom

#    OpenAirInterface is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.


#    OpenAirInterface is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with OpenAirInterface.The full GNU General Public License is 
#   included in this distribution in the file called "COPYING". If not, 
#   see <http://www.gnu.org/licenses/>.

#  Contact Information
#  OpenAirInterface Admin: openair_admin@eurecom.fr
#  OpenAirInterface Tech : openair_tech@eurecom.fr
#  OpenAirInterface Dev  : openair4g-devel@lists.eurecom.fr
  
#  Address      : Eurecom, Campus SophiaTech, 450 Route des Chappes, CS 50193 - 06904 Biot Sophia Antipolis cedex, FRANCE

# *******************************************************************************/
# \author Navid Nikaein, Rohit Gupta

# To free unused memory else test setup runs out of memory

mem_threshold=0.2 #If free memory is less than this threshold, then VM drop cache is called
mem_tot=`vmstat -s -S k |grep "total memory" | awk '{print $1}'`
mem_free=`vmstat -s -S k |grep "free memory" | awk '{print $1}'`

mem_frac=`bc <<< "scale=4;$mem_free/$mem_tot"`
echo $mem_frac
#mem_frac=`bc <<< "scale=4;`echo $mem_free`/`echo $mem_tot`"`
echo "Total Memory = $mem_tot k "
echo "Free Memory = $mem_free k"
echo "Fraction free memory = $mem_frac "

res=`bc <<< "$mem_frac < 0.2" `

echo "Comparison Result = $res"

if [ "$res" == "1" ]
then
  echo "Free memory less than threshold = $mem_threshold"
  sudo -E bash -c 'echo 3 > /proc/sys/vm/drop_caches ' 
fi


