/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator
 * (https://openapi-generator.tech). https://openapi-generator.tech Do not edit
 * the class manually.
 */

#include "PDUSessionsCollectionApi.h"
#include "Helpers.h"
#include "smf_config.hpp"

extern smf::smf_config smf_cfg;

namespace oai {
namespace smf_server {
namespace api {

using namespace oai::smf_server::helpers;
using namespace oai::smf_server::model;

PDUSessionsCollectionApi::PDUSessionsCollectionApi(
    std::shared_ptr<Pistache::Rest::Router> rtr) {
  router = rtr;
}

void PDUSessionsCollectionApi::init() {
  setupRoutes();
}

void PDUSessionsCollectionApi::setupRoutes() {
  using namespace Pistache::Rest;

  Routes::Post(
      *router, base + smf_cfg.sbi_api_version + "/pdu-sessions",
      Routes::bind(&PDUSessionsCollectionApi::post_pdu_sessions_handler, this));

  // Default handler, called when a route is not found
  router->addCustomHandler(Routes::bind(
      &PDUSessionsCollectionApi::pdu_sessions_collection_api_default_handler,
      this));
}

void PDUSessionsCollectionApi::post_pdu_sessions_handler(
    const Pistache::Rest::Request& request,
    Pistache::Http::ResponseWriter response) {
  // Getting the body param

  PduSessionCreateData pduSessionCreateData;

  try {
    nlohmann::json::parse(request.body()).get_to(pduSessionCreateData);
    this->post_pdu_sessions(pduSessionCreateData, response);
  } catch (nlohmann::detail::exception& e) {
    // send a 400 error
    response.send(Pistache::Http::Code::Bad_Request, e.what());
    return;
  } catch (std::exception& e) {
    // send a 500 error
    response.send(Pistache::Http::Code::Internal_Server_Error, e.what());
    return;
  }
}

void PDUSessionsCollectionApi::pdu_sessions_collection_api_default_handler(
    const Pistache::Rest::Request&, Pistache::Http::ResponseWriter response) {
  response.send(
      Pistache::Http::Code::Not_Found, "The requested method does not exist");
}

}  // namespace api
}  // namespace smf_server
}  // namespace oai
