#include "SmfToDataApi.h"
#include "Helpers.h"
#include "smf_config.hpp"

extern smf::smf_config smf_cfg;

namespace oai {
namespace smf_server {
namespace api {

using namespace oai::smf_server::helpers;

SmfToDataApi::SmfToDataApi(
    std::shared_ptr<Pistache::Rest::Router> rtr) {
  router = rtr;
}

void SmfToDataApi::init() {
  setupRoutes();
}

void SmfToDataApi::setupRoutes() {
  using namespace Pistache::Rest;
  //获取uemsg
  Routes::Get(
        *router, base + "/v1/uemsg/", 
        Routes::bind(&SmfToDataApi::uemsg_get_am_data_handler, this));
  router->addCustomHandler(Routes::bind(&SmfToDataApi::uemsg_default_handler, this));
  
}
//获取uemsg
void SmfToDataApi::uemsg_get_am_data_handler(const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response) {
    
    try {
         this->uemsg_get_am_data(response);
    } catch (nlohmann::detail::exception &e) {
        //send a 400 error
        response.send(Pistache::Http::Code::Bad_Request, e.what());
        return;
    } catch (Pistache::Http::HttpError &e) {
        response.send(static_cast<Pistache::Http::Code>(e.code()), e.what());
        return;
    } catch (std::exception &e) {
        response.send(Pistache::Http::Code::Internal_Server_Error, e.what());
        return;
    }
}
void SmfToDataApi::uemsg_default_handler(const Pistache::Rest::Request &, Pistache::Http::ResponseWriter response) {
    response.send(Pistache::Http::Code::Not_Found, "The requested method does not exist");
}

}  // namespace api
}  // namespace smf_server
}  // namespace oai
