#ifndef SMF_TO_DATA_API_IMPL_H_
#define SMF_TO_DATA_API_IMPL_H_

#include <pistache/endpoint.h>
#include <pistache/http.h>
#include <pistache/router.h>
#include <memory>
#include <pistache/optional.h>
#include "smf_app.hpp"
#include "conversions.hpp"

#include <SmfToDataApi.h>


namespace oai {
namespace smf_server {
namespace api {


class SmfToDataApiImpl
    : public oai::smf_server::api::SmfToDataApi {
 public:
  SmfToDataApiImpl(
      std::shared_ptr<Pistache::Rest::Router>, smf::smf_app* smf_app_inst,
      std::string address);
  ~SmfToDataApiImpl() {}
  //获取uemsg
  void uemsg_get_am_data(
      Pistache::Http::ResponseWriter& response);
  void set_supi(const supi_t& s);

  supi_t get_supi() const;
  bool ipv4;  
  struct in_addr
      ipv4_address; 

 private:
  smf::smf_app* m_smf_app;
  std::string m_address;

  supi_t supi;

 protected:
 


};

}  // namespace api
}  // namespace smf_server
}  // namespace oai

#endif
