/**
 * Nsmf_EventExposure
 * Session Management Event Exposure Service. © 2019, 3GPP Organizational
 * Partners (ARIB, ATIS, CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator
 * (https://openapi-generator.tech). https://openapi-generator.tech Do not edit
 * the class manually.
 */
/*
 * NsmfEventExposure.h
 *
 *
 */

#ifndef NsmfEventExposure_H_
#define NsmfEventExposure_H_

#include "EventSubscription.h"
#include "NotificationMethod.h"
#include <string>
#include "Ipv6Addr.h"
#include <vector>
#include "Guami.h"
#include <nlohmann/json.hpp>

namespace oai {
namespace smf_server {
namespace model {

/// <summary>
///
/// </summary>
class NsmfEventExposure {
 public:
  NsmfEventExposure();
  virtual ~NsmfEventExposure();

  void validate();

  /////////////////////////////////////////////
  /// NsmfEventExposure members

  /// <summary>
  ///
  /// </summary>
  std::string getSupi() const;
  void setSupi(std::string const& value);
  bool supiIsSet() const;
  void unsetSupi();
  /// <summary>
  ///
  /// </summary>
  std::string getGpsi() const;
  void setGpsi(std::string const& value);
  bool gpsiIsSet() const;
  void unsetGpsi();
  /// <summary>
  /// Any UE indication. This IE shall be present if the event subscription is
  /// applicable to any UE. Default value \&quot;FALSE\&quot; is used, if not
  /// present.
  /// </summary>
  bool isAnyUeInd() const;
  void setAnyUeInd(bool const value);
  bool anyUeIndIsSet() const;
  void unsetAnyUeInd();
  /// <summary>
  ///
  /// </summary>
  std::string getGroupId() const;
  void setGroupId(std::string const& value);
  bool groupIdIsSet() const;
  void unsetGroupId();
  /// <summary>
  ///
  /// </summary>
  int32_t getPduSeId() const;
  void setPduSeId(int32_t const value);
  bool pduSeIdIsSet() const;
  void unsetPduSeId();
  /// <summary>
  /// Identifies an Individual SMF Notification Subscription. To enable that the
  /// value is used as part of a URI, the string shall only contain characters
  /// allowed according to the \&quot;lower-with-hyphen\&quot; naming convention
  /// defined in 3GPP TS 29.501 [2]. In an OpenAPI [10] schema, the format shall
  /// be designated as \&quot;SubId\&quot;.
  /// </summary>
  std::string getSubId() const;
  void setSubId(std::string const& value);
  bool subIdIsSet() const;
  void unsetSubId();
  /// <summary>
  /// Notification Correlation ID assigned by the NF service consumer.
  /// </summary>
  std::string getNotifId() const;
  void setNotifId(std::string const& value);
  /// <summary>
  ///
  /// </summary>
  std::string getNotifUri() const;
  void setNotifUri(std::string const& value);
  /// <summary>
  /// Alternate or backup IPv4 Addess(es) where to send Notifications.
  /// </summary>
  std::vector<std::string>& getAltNotifIpv4Addrs();
  void setAltNotifIpv4Addrs(std::vector<std::string> const& value);
  bool altNotifIpv4AddrsIsSet() const;
  void unsetAltNotifIpv4Addrs();
  /// <summary>
  /// Alternate or backup IPv6 Addess(es) where to send Notifications.
  /// </summary>
  std::vector<Ipv6Addr>& getAltNotifIpv6Addrs();
  void setAltNotifIpv6Addrs(std::vector<Ipv6Addr> const& value);
  bool altNotifIpv6AddrsIsSet() const;
  void unsetAltNotifIpv6Addrs();
  /// <summary>
  /// Subscribed events
  /// </summary>
  std::vector<EventSubscription>& getEventSubs();
  void setEventSubs(std::vector<EventSubscription> const& value);
  /// <summary>
  ///
  /// </summary>
  bool isImmeRep() const;
  void setImmeRep(bool const value);
  bool immeRepIsSet() const;
  void unsetImmeRep();
  /// <summary>
  ///
  /// </summary>
  NotificationMethod getNotifMethod() const;
  void setNotifMethod(NotificationMethod const& value);
  bool notifMethodIsSet() const;
  void unsetNotifMethod();
  /// <summary>
  ///
  /// </summary>
  int32_t getMaxReportNbr() const;
  void setMaxReportNbr(int32_t const value);
  bool maxReportNbrIsSet() const;
  void unsetMaxReportNbr();
  /// <summary>
  ///
  /// </summary>
  std::string getExpiry() const;
  void setExpiry(std::string const& value);
  bool expiryIsSet() const;
  void unsetExpiry();
  /// <summary>
  ///
  /// </summary>
  int32_t getRepPeriod() const;
  void setRepPeriod(int32_t const value);
  bool repPeriodIsSet() const;
  void unsetRepPeriod();
  /// <summary>
  ///
  /// </summary>
  Guami getGuami() const;
  void setGuami(Guami const& value);
  bool guamiIsSet() const;
  void unsetGuami();
  /// <summary>
  /// If the NF service consumer is an AMF, it should provide the name of a
  /// service produced by the AMF that makes use of notifications about
  /// subscribed events.
  /// </summary>
  std::string getServiveName() const;
  void setServiveName(std::string const& value);
  bool serviveNameIsSet() const;
  void unsetServiveName();
  /// <summary>
  ///
  /// </summary>
  std::string getSupportedFeatures() const;
  void setSupportedFeatures(std::string const& value);
  bool supportedFeaturesIsSet() const;
  void unsetSupportedFeatures();

  friend void to_json(nlohmann::json& j, const NsmfEventExposure& o);
  friend void from_json(const nlohmann::json& j, NsmfEventExposure& o);

 protected:
  std::string m_Supi;
  bool m_SupiIsSet;
  std::string m_Gpsi;
  bool m_GpsiIsSet;
  bool m_AnyUeInd;
  bool m_AnyUeIndIsSet;
  std::string m_GroupId;
  bool m_GroupIdIsSet;
  int32_t m_PduSeId;
  bool m_PduSeIdIsSet;
  std::string m_SubId;
  bool m_SubIdIsSet;
  std::string m_NotifId;

  std::string m_NotifUri;

  std::vector<std::string> m_AltNotifIpv4Addrs;
  bool m_AltNotifIpv4AddrsIsSet;
  std::vector<Ipv6Addr> m_AltNotifIpv6Addrs;
  bool m_AltNotifIpv6AddrsIsSet;
  std::vector<EventSubscription> m_EventSubs;

  bool m_ImmeRep;
  bool m_ImmeRepIsSet;
  NotificationMethod m_NotifMethod;
  bool m_NotifMethodIsSet;
  int32_t m_MaxReportNbr;
  bool m_MaxReportNbrIsSet;
  std::string m_Expiry;
  bool m_ExpiryIsSet;
  int32_t m_RepPeriod;
  bool m_RepPeriodIsSet;
  Guami m_Guami;
  bool m_GuamiIsSet;
  std::string m_ServiveName;
  bool m_ServiveNameIsSet;
  std::string m_SupportedFeatures;
  bool m_SupportedFeaturesIsSet;
};

}  // namespace model
}  // namespace smf_server
}  // namespace oai

#endif /* NsmfEventExposure_H_ */
