/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

/*
 * IndividualSMContextApi.h
 *
 *
 */

#ifndef IndividualSMContextApi_H_
#define IndividualSMContextApi_H_

#include <pistache/http.h>
#include <pistache/router.h>
#include <pistache/http_headers.h>
#include <pistache/optional.h>

#include "ProblemDetails.h"
#include "SmContextReleaseData.h"
#include "SmContextRetrieveData.h"
#include "SmContextRetrievedData.h"
#include "SmContextUpdateData.h"
#include "SmContextUpdateError.h"
#include "SmContextUpdatedData.h"
#include "SmContextUpdateMessage.h"
#include "SmContextReleaseMessage.h"

#include "SmContextMessage.h"
#include "SmContextCreateError.h"
#include "SmContextCreatedData.h"
#include "smf.h"

namespace oai {
namespace smf_server {
namespace api {

using namespace oai::smf_server::model;

class IndividualSMContextApi {
 public:
  IndividualSMContextApi(std::shared_ptr<Pistache::Rest::Router>);
  virtual ~IndividualSMContextApi() {}
  void init();

  const std::string base = NSMF_PDU_SESSION_BASE;

 private:
  void setupRoutes();

  void release_sm_context_handler(
      const Pistache::Rest::Request& request,
      Pistache::Http::ResponseWriter response);
  void retrieve_sm_context_handler(
      const Pistache::Rest::Request& request,
      Pistache::Http::ResponseWriter response);
  void update_sm_context_handler(
      const Pistache::Rest::Request& request,
      Pistache::Http::ResponseWriter response);
  void individual_sm_context_api_default_handler(
      const Pistache::Rest::Request& request,
      Pistache::Http::ResponseWriter response);

  std::shared_ptr<Pistache::Rest::Router> router;

  /// <summary>
  /// Release SM Context
  /// </summary>
  /// <remarks>
  ///
  /// </remarks>
  /// <param name="smContextRef">SM context reference</param>
  /// <param name="smContextReleaseData">representation of the data to be sent
  /// to the SMF when releasing the SM context (optional)</param>
  virtual void release_sm_context(
      const std::string& smContextRef,
      const SmContextReleaseMessage& smContextReleaseMessage,
      Pistache::Http::ResponseWriter& response) = 0;

  /// <summary>
  /// Retrieve SM Context
  /// </summary>
  /// <remarks>
  ///
  /// </remarks>
  /// <param name="smContextRef">SM context reference</param>
  /// <param name="smContextRetrieveData">parameters used to retrieve the SM
  /// context (optional)</param>
  virtual void retrieve_sm_context(
      const std::string& smContextRef,
      const SmContextRetrieveData& smContextRetrieveData,
      Pistache::Http::ResponseWriter& response) = 0;

  /// <summary>
  /// Update SM Context
  /// </summary>
  /// <remarks>
  ///
  /// </remarks>
  /// <param name="smContextRef">SM context reference</param>
  /// <param name="smContextUpdateData">representation of the updates to apply
  /// to the SM context</param>
  virtual void update_sm_context(
      const std::string& smContextRef,
      const SmContextUpdateMessage& smContextUpdateMessage,
      Pistache::Http::ResponseWriter& response) = 0;
};

}  // namespace api
}  // namespace smf_server
}  // namespace oai

#endif /* IndividualSMContextApi_H_ */
