/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

/*
 * NFStatusNotifyApi.h
 *
 *
 */

#ifndef NFStatusNotifyApi_H_
#define NFStatusNotifyApi_H_

#include <pistache/http.h>
#include <pistache/router.h>
#include <pistache/http_headers.h>
#include <pistache/optional.h>

#include "NotificationData.h"
#include "ProblemDetails.h"

namespace oai {
namespace smf_server {
namespace api {

using namespace oai::smf_server::model;

class NFStatusNotifyApi {
 public:
  NFStatusNotifyApi(std::shared_ptr<Pistache::Rest::Router>);
  virtual ~NFStatusNotifyApi() {}
  void init();

  const std::string base = "/nsmf-nfstatus-notify/";

 private:
  void setupRoutes();

  void notify_nf_status_handler(
      const Pistache::Rest::Request& request,
      Pistache::Http::ResponseWriter response);
  void notify_nf_status_default_handler(
      const Pistache::Rest::Request& request,
      Pistache::Http::ResponseWriter response);

  std::shared_ptr<Pistache::Rest::Router> router;

  /// <summary>
  ///
  /// </summary>
  /// <remarks>
  ///
  /// </remarks>
  /// <param name="NotificationData"></param>
  virtual void receive_nf_status_notification(
      const NotificationData& notificationData,
      Pistache::Http::ResponseWriter& response) = 0;
};

}  // namespace api
}  // namespace smf_server
}  // namespace oai

#endif /* NFStatusNotifyApi_H_ */
