/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

/*
 * SMContextsCollectionApi.h
 *
 *
 */

#ifndef SMContextsCollectionApi_H_
#define SMContextsCollectionApi_H_

#include <pistache/http.h>
#include <pistache/router.h>
#include <pistache/http_headers.h>
#include <pistache/optional.h>

#include "SmContextMessage.h"
#include "ProblemDetails.h"
#include "SmContextCreateError.h"
#include "SmContextCreatedData.h"
#include "smf.h"

namespace oai {
namespace smf_server {
namespace api {

using namespace oai::smf_server::model;

class SMContextsCollectionApi {
 public:
  SMContextsCollectionApi(std::shared_ptr<Pistache::Rest::Router>);
  virtual ~SMContextsCollectionApi() {}
  void init();

  const std::string base = NSMF_PDU_SESSION_BASE;

 private:
  void setupRoutes();

  void post_sm_contexts_handler(
      const Pistache::Rest::Request& request,
      Pistache::Http::ResponseWriter response);
  void sm_contexts_collection_api_default_handler(
      const Pistache::Rest::Request& request,
      Pistache::Http::ResponseWriter response);

  std::shared_ptr<Pistache::Rest::Router> router;

  /// <summary>
  /// Create SM Context
  /// </summary>
  /// <remarks>
  ///
  /// </remarks>
  /// <param name="smContextMessage"></param>
  virtual void post_sm_contexts(
      const SmContextMessage& smContextMessage,
      Pistache::Http::ResponseWriter& response) = 0;
};

}  // namespace api
}  // namespace smf_server
}  // namespace oai

#endif /* SMContextsCollectionApi_H_ */
