#ifndef SmfToDataApi_H_
#define SmfToDataApi_H_

#include <pistache/http.h>
#include <pistache/router.h>
#include <pistache/http_headers.h>
#include <pistache/optional.h>


namespace oai {
namespace smf_server {
namespace api {


class SmfToDataApi {
 public:
  SmfToDataApi(std::shared_ptr<Pistache::Rest::Router>);
  virtual ~SmfToDataApi() {}
  void init();

  const std::string base = "/openxg-smf/";

 private:
    void setupRoutes();
  std::shared_ptr<Pistache::Rest::Router> router;
  
    //获取uemsg
    void uemsg_get_am_data_handler(
        const Pistache::Rest::Request &request,              
        Pistache::Http::ResponseWriter response);
    void uemsg_default_handler(
        const Pistache::Rest::Request &request, Pistache::Http::ResponseWriter response);
    virtual void uemsg_get_am_data(
        Pistache::Http::ResponseWriter &response)=0;

};

}  // namespace api
}  // namespace smf_server
}  // namespace oai

#endif /* SmfToDataApi_H_ */
