/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#include "IndividualPDUSessionHSMFApiImpl.h"

namespace oai {
namespace smf_server {
namespace api {

using namespace oai::smf_server::model;

IndividualPDUSessionHSMFApiImpl::IndividualPDUSessionHSMFApiImpl(
    std::shared_ptr<Pistache::Rest::Router> rtr, smf::smf_app* smf_app_inst,
    std::string address)
    : IndividualPDUSessionHSMFApi(rtr),
      m_smf_app(smf_app_inst),
      m_address(address) {}

void IndividualPDUSessionHSMFApiImpl::release_pdu_session(
    const std::string& pduSessionRef, const ReleaseData& releaseData,
    Pistache::Http::ResponseWriter& response) {
  Logger::smf_api_server().info("release_pdu_session...");
  response.send(
      Pistache::Http::Code::Not_Implemented,
      "Release_pdu_session API has not been implemented yet!\n");
}
void IndividualPDUSessionHSMFApiImpl::update_pdu_session(
    const std::string& pduSessionRef, const HsmfUpdateData& hsmfUpdateData,
    Pistache::Http::ResponseWriter& response) {
  Logger::smf_api_server().info("update_pdu_session...");
  response.send(
      Pistache::Http::Code::Not_Implemented,
      "Update_pdu_session API has not been implemented yet!\n");
}

}  // namespace api
}  // namespace smf_server
}  // namespace oai
