/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

/*
 * IndividualSMContextApiImpl.h
 *
 *
 */

#ifndef INDIVIDUAL_SM_CONTEXT_API_IMPL_H_
#define INDIVIDUAL_SM_CONTEXT_API_IMPL_H_

#include <pistache/endpoint.h>
#include <pistache/http.h>
#include <pistache/router.h>
#include <memory>

#include <IndividualSMContextApi.h>

#include <pistache/optional.h>

#include "ProblemDetails.h"
#include "SmContextReleaseData.h"
#include "SmContextRetrieveData.h"
#include "SmContextRetrievedData.h"
#include "SmContextUpdateData.h"
#include "SmContextUpdateError.h"
#include "SmContextUpdatedData.h"
#include "SmContextUpdateMessage.h"
#include "SmContextReleaseMessage.h"
#include <string>
#include "smf_app.hpp"

namespace oai {
namespace smf_server {
namespace api {

using namespace oai::smf_server::model;

class IndividualSMContextApiImpl
    : public oai::smf_server::api::IndividualSMContextApi {
 public:
  IndividualSMContextApiImpl(
      std::shared_ptr<Pistache::Rest::Router>, smf::smf_app* smf_app_inst,
      std::string address);
  ~IndividualSMContextApiImpl() {}

  void release_sm_context(
      const std::string& smContextRef,
      const SmContextReleaseMessage& smContextReleaseMessage,
      Pistache::Http::ResponseWriter& response);
  void retrieve_sm_context(
      const std::string& smContextRef,
      const SmContextRetrieveData& smContextRetrieveData,
      Pistache::Http::ResponseWriter& response);
  void update_sm_context(
      const std::string& smContextRef,
      const SmContextUpdateMessage& smContextUpdateMessage,
      Pistache::Http::ResponseWriter& response);

 private:
  smf::smf_app* m_smf_app;
  std::string m_address;

 protected:
  static uint64_t generate_promise_id() {
    return util::uint_uid_generator<uint64_t>::get_instance().get_uid();
  }
};

}  // namespace api
}  // namespace smf_server
}  // namespace oai

#endif
