/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

/*
 * IndividualSubscriptionDocumentApiImpl.h
 *
 *
 */

#ifndef INDIVIDUAL_SUBSCRIPTION_DOCUMENT_API_IMPL_H_
#define INDIVIDUAL_SUBSCRIPTION_DOCUMENT_API_IMPL_H_

#include <pistache/endpoint.h>
#include <pistache/http.h>
#include <pistache/router.h>
#include <memory>

#include <IndividualSubscriptionDocumentApi.h>

#include <pistache/optional.h>

#include "NsmfEventExposure.h"
#include "ProblemDetails.h"
#include "smf_app.hpp"
#include <string>

namespace oai {
namespace smf_server {
namespace api {

using namespace oai::smf_server::model;

class IndividualSubscriptionDocumentApiImpl
    : public oai::smf_server::api::IndividualSubscriptionDocumentApi {
 public:
  IndividualSubscriptionDocumentApiImpl(
      std::shared_ptr<Pistache::Rest::Router>, smf::smf_app* smf_app_inst,
      std::string address);
  ~IndividualSubscriptionDocumentApiImpl() {}

  void delete_individual_subcription(
      const std::string& subId, Pistache::Http::ResponseWriter& response);
  void get_individual_subcription(
      const std::string& subId, Pistache::Http::ResponseWriter& response);
  void replace_individual_subcription(
      const std::string& subId, const NsmfEventExposure& nsmfEventExposure,
      Pistache::Http::ResponseWriter& response);

 private:
  smf::smf_app* m_smf_app;
  std::string m_address;
};

}  // namespace api
}  // namespace smf_server
}  // namespace oai

#endif
