/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

/*
 * PDUSessionsCollectionApiImpl.h
 *
 *
 */

#ifndef PDU_SESSIONS_COLLECTION_API_IMPL_H_
#define PDU_SESSIONS_COLLECTION_API_IMPL_H_

#include <pistache/endpoint.h>
#include <pistache/http.h>
#include <pistache/router.h>
#include <memory>

#include <PDUSessionsCollectionApi.h>

#include <pistache/optional.h>

#include "PduSessionCreateData.h"
#include "PduSessionCreateError.h"
#include "PduSessionCreatedData.h"
#include "ProblemDetails.h"
#include "smf_app.hpp"

namespace oai {
namespace smf_server {
namespace api {

using namespace oai::smf_server::model;

class PDUSessionsCollectionApiImpl
    : public oai::smf_server::api::PDUSessionsCollectionApi {
 public:
  PDUSessionsCollectionApiImpl(
      std::shared_ptr<Pistache::Rest::Router>, smf::smf_app* smf_app_inst,
      std::string address);
  ~PDUSessionsCollectionApiImpl() {}

  void post_pdu_sessions(
      const PduSessionCreateData& pduSessionCreateData,
      Pistache::Http::ResponseWriter& response);

 private:
  smf::smf_app* m_smf_app;
  std::string m_address;
};

}  // namespace api
}  // namespace smf_server
}  // namespace oai

#endif
