/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef FILE_SMF_API_SERVER_SEEN
#define FILE_SMF_API_SERVER_SEEN

#include "pistache/endpoint.h"
#include "pistache/http.h"
#include "pistache/router.h"
#ifdef __linux__
#include <vector>
#include <signal.h>
#include <unistd.h>
#endif

#include "IndividualPDUSessionHSMFApiImpl.h"
#include "IndividualSMContextApiImpl.h"
#include "PDUSessionsCollectionApiImpl.h"
#include "SMContextsCollectionApiImpl.h"
#include "IndividualSubscriptionDocumentApiImpl.h"
#include "SubscriptionsCollectionApiImpl.h"
#include "NFStatusNotifyApiImpl.h"
#include "SmfToDataApiImpl.h"

#include "smf_app.hpp"

using namespace oai::smf_server::api;
class SMFApiServer {
 public:
  SMFApiServer(Pistache::Address address, smf::smf_app* smf_app_inst)
      : m_httpEndpoint(std::make_shared<Pistache::Http::Endpoint>(address)) {
    m_router  = std::make_shared<Pistache::Rest::Router>();
    m_address = address.host() + ":" + (address.port()).toString();
    m_individualPDUSessionHSMFApiImpl =
        std::make_shared<IndividualPDUSessionHSMFApiImpl>(
            m_router, smf_app_inst, m_address);
    m_individualSMContextApiImpl = std::make_shared<IndividualSMContextApiImpl>(
        m_router, smf_app_inst, m_address);
    m_pduSessionsCollectionApiImpl =
        std::make_shared<PDUSessionsCollectionApiImpl>(
            m_router, smf_app_inst, m_address);
    m_smContextsCollectionApiImpl =
        std::make_shared<SMContextsCollectionApiImpl>(
            m_router, smf_app_inst, m_address);
    m_individualSubscriptionDocumentApiImpl =
        std::make_shared<IndividualSubscriptionDocumentApiImpl>(
            m_router, smf_app_inst, m_address);
    m_subscriptionsCollectionApiImpl =
        std::make_shared<SubscriptionsCollectionApiImpl>(
            m_router, smf_app_inst, m_address);
    m_nfStatusNotifyApiImpl = std::make_shared<NFStatusNotifyApiImpl>(
        m_router, smf_app_inst, m_address);
    m_smfToDataApiImpl = std::make_shared<SmfToDataApiImpl>(
        m_router, smf_app_inst, m_address);
  }
  void init(size_t thr = 1);
  void start();
  void shutdown();

 private:
  std::shared_ptr<Pistache::Http::Endpoint> m_httpEndpoint;
  std::shared_ptr<Pistache::Rest::Router> m_router;
  std::shared_ptr<IndividualPDUSessionHSMFApiImpl>
      m_individualPDUSessionHSMFApiImpl;
  std::shared_ptr<IndividualSMContextApiImpl> m_individualSMContextApiImpl;
  std::shared_ptr<PDUSessionsCollectionApiImpl> m_pduSessionsCollectionApiImpl;
  std::shared_ptr<SMContextsCollectionApiImpl> m_smContextsCollectionApiImpl;
  std::shared_ptr<IndividualSubscriptionDocumentApiImpl>
      m_individualSubscriptionDocumentApiImpl;
  std::shared_ptr<SubscriptionsCollectionApiImpl>
      m_subscriptionsCollectionApiImpl;
  std::shared_ptr<NFStatusNotifyApiImpl> m_nfStatusNotifyApiImpl;
  std::shared_ptr<SmfToDataApiImpl> m_smfToDataApiImpl;

  std::string m_address;
};

#endif
