/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef FILE_3GPP_29_503_SMF_SEEN
#define FILE_3GPP_29_503_SMF_SEEN

#include "smf.h"
#include "3gpp_29.571.h"

enum ssc_mode_e {
  SSC_MODE_1 = 1,
  SSC_MODE_2 = 2,
  SSC_MODE_3 = 3,
};
static const std::vector<std::string> ssc_mode_e2str = {
    "Error", "SSC_MODE_1", "SSC_MODE_2", "SSC_MODE_3"};

typedef struct ssc_mode_s {
  uint8_t ssc_mode;
  ssc_mode_s() : ssc_mode(SSC_MODE_1) {}
  ssc_mode_s(ssc_mode_e mode) : ssc_mode(mode) {}
  ssc_mode_s(const struct ssc_mode_s& p) : ssc_mode(p.ssc_mode) {}
} ssc_mode_t;

typedef struct pdu_session_types_s {
  pdu_session_type_t default_session_type;
  std::vector<pdu_session_type_t> allowed_session_types;
} pdu_session_types_t;

typedef struct ssc_modes_s {
  ssc_mode_t default_ssc_mode;
  std::vector<ssc_mode_t> allowed_ssc_modes;
} ssc_modes_t;

typedef struct dnn_configuration_s {
  pdu_session_types_t pdu_session_types;
  ssc_modes_t ssc_modes;
  session_ambr_t session_ambr;
  subscribed_default_qos_t _5g_qos_profile;
  // staticIpAddresses
} dnn_configuration_t;

#endif
