/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

/*! \file common_root_types.h
 \brief
 \company Eurecom
 \email: lionel.gauthier@eurecom.fr
 */

#ifndef FILE_COMMON_ROOT_TYPES_SEEN
#define FILE_COMMON_ROOT_TYPES_SEEN

#include <stdint.h>
#include <inttypes.h>
#include <arpa/inet.h>

//------------------------------------------------------------------------------
#define PRIORITY_LEVEL_MAX (15)
#define PRIORITY_LEVEL_MIN (1)
#define BEARERS_PER_UE (11)
#define IMEI_DIGITS_MAX (15)
#define IMEISV_DIGITS_MAX (16)
#define MAX_APN_PER_UE (5)

#define PROC_ID_FMT "0x%" PRIx64

// TEIDs
typedef uint32_t teid_t;
#define TEID_FMT "0x%" PRIx32
#define TEID_SCAN_FMT SCNx32
#define INVALID_TEID ((teid_t) 0x00000000)
#define UNASSIGNED_TEID ((teid_t) 0x00000000)

// SEIDs
typedef uint64_t seid_t;
#define SEID_FMT "0x%" PRIx64
#define SEID_SCAN_FMT SCNx64
#define INVALID_SEID ((seid_t) 0x00000000)
#define UNASSIGNED_SEID ((seid_t) 0x00000000)

// SM Context IDs (SCIDs)
typedef uint32_t scid_t;
#define SCID_FMT "0x%" PRIx32
#define SCID_SCAN_FMT SCNx32
#define INVALID_SCID ((scid_t) 0x00000000)
#define UNASSIGNED_SCID ((scid_t) 0x00000000)

// Event Subscription IDs)
typedef uint32_t evsub_id_t;
#define EVSUB_ID_FMT "0x%" PRIx32
#define EVSUB_ID_SCAN_FMT SCNx32
#define INVALID_EVSUB_ID ((evsub_id_t) 0x00000000)
#define UNASSIGNED_EVSUB_ID ((evsub_id_t) 0x00000000)

//------------------------------------------------------------------------------
// IMSI
typedef uint64_t imsi64_t;
#define IMSI_64_FMT "%" SCNu64
#define INVALID_IMSI64 (imsi64_t) 0

//------------------------------------------------------------------------------
typedef uint64_t bitrate_t;
#define PRIORITY_LEVEL_FMT "0x%" PRIu8
#define QCI_FMT "0x%" PRIu8
#define QCI_SCAN_FMT SCNu8

#define PRE_EMPTION_CAPABILITY_FMT "0x%" PRIu8
#define PRE_EMPTION_VULNERABILITY_FMT "0x%" PRIu8

#endif /* FILE_COMMON_ROOT_TYPES_SEEN */
