/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#include <stdlib.h>
#include "dynamic_memory_check.h"
#include "assertions.h"

//------------------------------------------------------------------------------
void free_wrapper(void** ptr) {
  // for debug only
  AssertFatal(ptr, "Trying to free NULL ptr");
  if (ptr) {
    free(*ptr);
    *ptr = NULL;
  }
}

//------------------------------------------------------------------------------
void bdestroy_wrapper(bstring* b) {
  if ((b) && (*b)) {
    bdestroy(*b);
    *b = NULL;
  }
}
