/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

/*
 *  itti_msg_nx.hpp
 *
 *  Created on:
 *  Author:
 */

#ifndef ITTI_MSG_NX_HPP_INCLUDED_
#define ITTI_MSG_NX_HPP_INCLUDED_

#include "itti_msg.hpp"
#include "smf_msg.hpp"
#include "pistache/http.h"

class itti_nx_msg : public itti_msg {
 public:
  itti_nx_msg(
      const itti_msg_type_t msg_type, const task_id_t orig,
      const task_id_t dest)
      : itti_msg(msg_type, orig, dest) {}
  itti_nx_msg(const itti_nx_msg& i) : itti_msg(i) {}
  itti_nx_msg(const itti_nx_msg& i, const task_id_t orig, const task_id_t dest)
      : itti_nx_msg(i) {
    origin      = orig;
    destination = dest;
  }
};

//-----------------------------------------------------------------------------
class itti_nx_trigger_pdu_session_modification : public itti_nx_msg {
 public:
  itti_nx_trigger_pdu_session_modification(
      const task_id_t orig, const task_id_t dest)
      : itti_nx_msg(NX_TRIGGER_SESSION_MODIFICATION, orig, dest),
        msg(),
        http_version() {}
  itti_nx_trigger_pdu_session_modification(
      const itti_nx_trigger_pdu_session_modification& i)
      : itti_nx_msg(i), msg(i.msg), http_version(i.http_version) {}
  itti_nx_trigger_pdu_session_modification(
      const itti_nx_trigger_pdu_session_modification& i, const task_id_t orig,
      const task_id_t dest)
      : itti_nx_msg(i, orig, dest), msg(), http_version(i.http_version) {}
  const char* get_msg_name() { return "NX_TRIGGER_PDU_SESSION_MODIFICATION"; };
  smf::pdu_session_modification_network_requested msg;
  uint8_t http_version;
};

#endif /* ITTI_MSG_NX_HPP_INCLUDED_ */
