/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef FILE_3GPP_24_007_SEEN
#define FILE_3GPP_24_007_SEEN

#include <stdint.h>

typedef enum extended_protocol_discriminator_e {
  // 5G Session Management
  EPD_5GS_SESSION_MANAGEMENT_MESSAGES = 0x2e,
  // 5G Mobility Management
  EPD_5GS_MOBILITY_MANAGEMENT_MESSAGES = 0x7e,

} extended_protocol_discriminator_t;

// Procedure transaction identity
// 8 bits
#define PROCEDURE_TRANSACTION_IDENTITY_UNASSIGNED (uint8_t) 0
#define PROCEDURE_TRANSACTION_IDENTITY_FIRST (uint8_t) 1
#define PROCEDURE_TRANSACTION_IDENTITY_LAST (uint8_t) 254
#define PROCEDURE_TRANSACTION_IDENTITY_RESERVED (uint8_t) 255

// PDU Session Identity
typedef uint8_t pdu_session_id_t;

// 8 bits
#define PDU_SESSION_IDENTITY_UNASSIGNED (uint8_t) 0
#define PDU_SESSION_IDENTITY_FIRST (uint8_t) 1
#define PDU_SESSION_IDENTITY_LAST (uint8_t) 15

// QFI
// type: integer,  minimum: 0, maximum: 63
#define NO_QOS_FLOW_IDENTIFIER_ASSIGNED (uint8_t) 0
#define QOS_FLOW_IDENTIFIER_FIRST (uint8_t) 1
#define QOS_FLOW_IDENTIFIER_LAST (uint8_t) 63

// QoS Rule
#define NO_QOS_RULE_IDENTIFIER_ASSIGNED (uint8_t) 0
#define QOS_RULE_IDENTIFIER_FIRST (uint8_t) 1
#define QOS_RULE_IDENTIFIER_LAST (uint8_t) 255

// Integrity protection maximum data rate
typedef struct ipmdr_s {
  uint8_t ul;
  uint8_t dl;
} ipmdr_t;

#endif
