/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef FILE_COMMON_TYPES_SEEN
#define FILE_COMMON_TYPES_SEEN

#include "3gpp_38.401.h"
#include "3gpp_23.003.h"
#include "3gpp_24.007.h"
#include "3gpp_24.501.h"

typedef uint16_t sctp_stream_id_t;
typedef uint32_t sctp_assoc_id_t;

// UE NGAP IDs

#define INVALID_RAN_UE_NGAP_ID_KEY 0xFFFFFFFFFFFFFFFF
#define RAN_UE_NGAP_ID_MASK 0x00FFFFFF
#define RAN_UE_NGAP_ID_FMT "0x%06" PRIX32
#define GNB_UE_NGAP_ID_FMT "0x%06" PRIX32
#define AMF_UE_NGAP_ID_FMT "0x%08" PRIX32
#define INVALID_AMF_UE_NGAP_ID 0x0

#define AMF_UE_NGAP_ID_MASK_ 0x0000FFFFFFFFFF

typedef uint8_t ksi_t;
#define KSI_NO_KEY_AVAILABLE 0x07

typedef uint32_t ipv4_nbo_t;

#endif
