/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef FILE_NAS_LIB_SEEN
#define FILE_NAS_LIB_SEEN
#include "bstrlib.h"

typedef struct pco_protocol_or_container_id_nas_s {
  uint16_t id;
  uint8_t length;
  bstring contents;
} pco_protocol_or_container_id_nas_t;

typedef struct protocol_configuration_options_nas_s {
  uint8_t ext : 1;
  uint8_t spare : 4;
  uint8_t configuration_protocol : 3;
  uint8_t num_protocol_or_container_id;
  // arbitrary value, can be greater than defined (250/3)
  // Setting this value to 30 to support maximum possible number of protocol id
  // or container id defined in 24.008 release 13
#define PCO_UNSPEC_MAXIMUM_PROTOCOL_ID_OR_CONTAINER_ID 30
  pco_protocol_or_container_id_nas_t
      protocol_or_container_ids[PCO_UNSPEC_MAXIMUM_PROTOCOL_ID_OR_CONTAINER_ID];
} protocol_configuration_options_nas_t;
#endif
