/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */



#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#include "bstrlib.h"

#include "TLVDecoder.h"

int errorCodeDecoder = 0;

//------------------------------------------------------------------------------
int decode_bstring(
    bstring* bstr, const uint16_t pdulen, const uint8_t* const buffer,
    const uint32_t buflen) {
  if (buflen < pdulen) {
    return TLV_BUFFER_TOO_SHORT;
  }

  if ((bstr) && (buffer)) {
    *bstr = blk2bstr(buffer, pdulen);
    return pdulen;
  } else {
    *bstr = NULL;
    return TLV_BUFFER_TOO_SHORT;
  }
}

//------------------------------------------------------------------------------
bstring dump_bstring_xml(const bstring bstr) {
  if (bstr) {
    int i;

    bstring b = bformat("<Length>%u</Length>\n\t<values>", bstr->slen);
    for (i = 0; i < bstr->slen; i++) {
      bformata(b, "0x%x ", bstr->data[i]);
    }
    bcatcstr(b, "</values>\n");
    return b;
  } else {
    bstring b = bfromcstr("<Length>0</Length>\n");
    return b;
  }
}
