/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */



#ifndef FILE_ASYNC_SHELL_CMD_HPP_SEEN
#define FILE_ASYNC_SHELL_CMD_HPP_SEEN

#include "itti_msg.hpp"
#include "thread_sched.hpp"
#include <string>
#include <thread>

namespace util {

class async_shell_cmd {
 private:
  std::thread::id thread_id;
  std::thread thread;

 public:
  explicit async_shell_cmd(util::thread_sched_params& sched_params);
  ~async_shell_cmd() {}
  async_shell_cmd(async_shell_cmd const&) = delete;
  void operator=(async_shell_cmd const&) = delete;

  int run_command(
      const task_id_t sender_itti_task, const bool is_abort_on_error,
      const char* src_file, const int src_line, const std::string& cmd_str);
};

}  // namespace util
#endif /* FILE_ASYNC_SHELL_CMD_HPP_SEEN */
