/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */


#ifndef FILE_IF_HPP_SEEN
#define FILE_IF_HPP_SEEN
#include <string>

int get_gateway_and_iface(std::string* gw /*OUT*/, std::string* iface /*OUT*/);
int get_inet_addr_from_iface(
    const std::string& if_name, struct in_addr& inet_addr);
int get_mtu_from_iface(const std::string& if_name, uint32_t& mtu);
int get_inet_addr_infos_from_iface(
    const std::string& if_name, struct in_addr& inet_addr,
    struct in_addr& inet_netmask, unsigned int& mtu);

#endif /* FILE_IF_HPP_SEEN */
