/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */


#ifndef FILE_PID_FILE_SEEN
#define FILE_PID_FILE_SEEN
#include <string>

namespace util {

/*
 * Generate the exe absolute path using a specified base_path.
 *@param base_path the root directory to use.
 *@return a string for the exe absolute path.
 */
std::string get_exe_absolute_path(
    const std::string& base_path, const unsigned int instance);

bool is_pid_file_lock_success(const char* pid_file_name);

void pid_file_unlock(void);

int lockfile(int fd, int lock_type);

}  // namespace util
#endif
