/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */


#ifndef FILE_STRING_HPP_FILE_SEEN
#define FILE_STRING_HPP_FILE_SEEN

#include <string>
#include <arpa/inet.h>

extern "C" {
#include "bstrlib.h"
}

namespace util {

std::string string_format(const char* format, ...);

std::string& ltrim(std::string& s);
// trim from end
std::string& rtrim(std::string& s);
// trim from both ends
std::string& trim(std::string& s);

void ipv4_to_bstring(struct in_addr ipv4_address, bstring str);

void ipv6_to_bstring(struct in6_addr ipv6_address, bstring str);

/*
 * Create a PDU Address Information in form of a bstring (byte 0-7: IPv6 prefix,
 * 8-11: Ipv4 Address)
 * @param [struct in_addr] ipv4_address: IPv4 address
 * @param [struct in6_addr ] ipv6_address: IPv6 address
 * @param [bstring] str: store the PDU Address Information
 * @return void
 */
void ipv4v6_to_pdu_address_information(
    struct in_addr ipv4_address, struct in6_addr ipv6_address, bstring str);

void string_to_bstring(const std::string& str, bstring bstr);
bool string_to_dotted(const std::string& str, std::string& dotted);
bool dotted_to_string(const std::string& dot, std::string& no_dot);
void string_to_dnn(const std::string& str, bstring bstr);
}  // namespace util
#endif
