/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

/*! \file thread_sched.cpp
 \brief
 \company Eurecom
 \email: lionel.gauthier@eurecom.fr
 */

#include "thread_sched.hpp"

//------------------------------------------------------------------------------
void util::thread_sched_params::apply(
    const int task_id, _Logger& logger) const {
  if (cpu_id >= 0) {
    cpu_set_t cpuset;
    CPU_SET(cpu_id, &cpuset);
    if (int rc = pthread_setaffinity_np(
            pthread_self(), sizeof(cpu_set_t), &cpuset)) {
      logger.warn(
          "Could not set affinity to ITTI task %d, err=%d", task_id, rc);
    }
  }

  struct sched_param sparam;
  memset(&sparam, 0, sizeof(sparam));
  sparam.sched_priority = sched_priority;
  if (int rc = pthread_setschedparam(pthread_self(), sched_policy, &sparam)) {
    logger.warn(
        "Could not set schedparam to ITTI task %d, err=%d", task_id, rc);
  }
}
