/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

/*! \file thread_sched.hpp
 \brief
 \company Eurecom
 \email: lionel.gauthier@eurecom.fr
 */

#ifndef FILE_THREAD_SCHED_HPP_SEEN
#define FILE_THREAD_SCHED_HPP_SEEN

#include <sched.h>
#include "logger.hpp"

namespace util {

class thread_sched_params {
 public:
  thread_sched_params()
      : cpu_id(0), sched_policy(SCHED_FIFO), sched_priority(84) {}
  int cpu_id;
  int sched_policy;
  int sched_priority;
  void apply(const int task_id, _Logger& logger) const;
};

}  // namespace util
#endif /* FILE_THREAD_SCHED_HPP_SEEN */
