/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#include "itti_msg.hpp"
#include "itti.hpp"

extern itti_mw* itti_inst;

itti_msg::itti_msg()
    : msg_type(ITTI_MSG_TYPE_NONE), origin(TASK_NONE), destination(TASK_NONE) {
  msg_num = itti_inst->increment_message_number();
};

itti_msg::itti_msg(
    const itti_msg_type_t msg_type, task_id_t origin, task_id_t destination)
    : msg_type(msg_type), origin(origin), destination(destination) {
  msg_num = itti_inst->increment_message_number();
};

itti_msg::itti_msg(const itti_msg& i)
    : msg_type(i.msg_type),
      msg_num(i.msg_num),
      origin(i.origin),
      destination(i.destination){};

const char* itti_msg::get_msg_name() {
  return "UNINITIALIZED";
}
