/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef _ADDITIONAL_5G_SECURITY_INFORMATION_H_
#define _ADDITIONAL_5G_SECURITY_INFORMATION_H_

#include <stdint.h>
#include "bstrlib.h"
#include <stdbool.h>

#define ADDITIONAL_5G_SECURITY_INFORMATION_MINIMUM_LENGTH 3
#define ADDITIONAL_5G_SECURITY_INFORMATION_MAXIMUM_LENGTH 3

#define KAMF_DERIVATION_IS_NOT_REQUIRED 0
#define KAMF_DERIVATION_IS_REQUIRED 1

#define RETRANSMISSION_OF_THE_INITIAL_NAS_MESSAGE_NOT_REQUESTED 0
#define RETRANSMISSION_OF_THE_INITIAL_NAS_MESSAGE_REQUESTED 1

typedef struct {
  bool hdp;
  bool rinmr;
} Additional5GSecurityInformation;

int encode_additional_5g_security_information(
    Additional5GSecurityInformation additional5gsecurityinformation,
    uint8_t iei, uint8_t* buffer, uint32_t len);
int decode_additional_5g_security_information(
    Additional5GSecurityInformation* additional5gsecurityinformation,
    uint8_t iei, uint8_t* buffer, uint32_t len);

#endif
