/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef _ALLOWEDSSCMODE_H_
#define _ALLOWEDSSCMODE_H_

#include <stdint.h>
#include <stdbool.h>
#include "bstrlib.h"

#define ALLOWED_SSC_MODE_MINIMUM_LENGTH 1
#define ALLOWED_SSC_MODE_MAXIMUM_LENGTH 1

#define SSC_MODE1_NOT_ALLOWED 0
#define SSC_MODE1_ALLOWED 1
#define SSC_MODE2_NOT_ALLOWED 0
#define SSC_MODE2_ALLOWED 1
#define SSC_MODE3_NOT_ALLOWED 0
#define SSC_MODE3_ALLOWED 1

// typedef bstring AllowedSSCMode;
typedef struct {
  bool is_ssc1_allowed;
  bool is_ssc2_allowed;
  bool is_ssc3_allowed;
} AllowedSSCMode;

int encode_allowed_ssc_mode(
    AllowedSSCMode allowedsscmode, uint8_t iei, uint8_t* buffer, uint32_t len);
int decode_allowed_ssc_mode(
    AllowedSSCMode* allowedsscmode, uint8_t iei, uint8_t* buffer, uint32_t len);

#endif
