/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef _ALWAYSONPDUSESSIONINDICATION_H_
#define _ALWAYSONPDUSESSIONINDICATION_H_

#include <stdint.h>
#include <stdbool.h>
#include "bstrlib.h"

#define ALWAYSON_PDU_SESSION_INDICATION_MINIMUM_LENGTH 1
#define ALWAYSON_PDU_SESSION_INDICATION_MAXIMUM_LENGTH 1

#define ALWAYSON_PDU_SESSION_NOT_ALLOWED 0
#define ALWAYSON_PDU_SESSION_REQUIRED 1

typedef struct {
  bool apsi_indication;
} AlwaysonPDUSessionIndication;

int encode_alwayson_pdu_session_indication(
    AlwaysonPDUSessionIndication alwaysonpdusessionindication, uint8_t iei,
    uint8_t* buffer, uint32_t len);
int decode_alwayson_pdu_session_indication(
    AlwaysonPDUSessionIndication* alwaysonpdusessionindication, uint8_t iei,
    uint8_t* buffer, uint32_t len);

#endif
