/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef _ALWAYSONPDUSESSIONREQUESTED_H_
#define _ALWAYSONPDUSESSIONREQUESTED_H_

#include <stdint.h>
#include <stdbool.h>
#include "bstrlib.h"

#define ALWAYSON_PDU_SESSION_REQUESTED_MINIMUM_LENGTH 1
#define ALWAYSON_PDU_SESSION_REQUESTED_MAXIMUM_LENGTH 1

#define ALWAYSON_PDU_SESSION_NOT_REQUESTED 0
#define ALWAYSON_PDU_SESSION_REQUESTED 1

typedef struct {
  bool apsr_requested;
} AlwaysonPDUSessionRequested;

int encode_alwayson_pdu_session_requested(
    AlwaysonPDUSessionRequested alwaysonpdusessionrequested, uint8_t iei,
    uint8_t* buffer, uint32_t len);
int decode_alwayson_pdu_session_requested(
    AlwaysonPDUSessionRequested* alwaysonpdusessionrequested, uint8_t iei,
    uint8_t* buffer, uint32_t len);

#endif
