/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef AUTHENTICATION_FAILURE_PARAMETER_H_
#define AUTHENTICATION_FAILURE_PARAMETER_H_

#include <stdint.h>
#include "bstrlib.h"

#define AUTHENTICATION_FAILURE_PARAMETER_MINIMUM_LENGTH 16
#define AUTHENTICATION_FAILURE_PARAMETER_MAXIMUM_LENGTH 16

typedef bstring AuthenticationFailureParameter;

int encode_authentication_failure_parameter(
    AuthenticationFailureParameter authenticationfailureparameter, uint8_t iei,
    uint8_t* buffer, uint32_t len);
int decode_authentication_failure_parameter(
    AuthenticationFailureParameter* authenticationfailureparameter, uint8_t iei,
    uint8_t* buffer, uint32_t len);

#endif
