/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef _EAPMESSAGE_H_
#define _EAPMESSAGE_H_

#include <stdint.h>
#include "bstrlib.h"

#define EAP_MESSAGE_MINIMUM_LENGTH 7
#define EAP_MESSAGE_MAXIMUM_LENGTH 1503

#define EAP_MESSAGE_MINIMUM_LENGTH_TLVE 7
#define EAP_MESSAGE_MAXIMUM_LENGTH_TLVE 1503
#define EAP_MESSAGE_MINIMUM_LENGTH_LVE 6
#define EAP_MESSAGE_MAXIMUM_LENGTH_LVE 1502

typedef bstring EAPMessage;

int encode_eap_message(
    EAPMessage eapmessage, uint8_t iei, uint8_t* buffer, uint32_t len);
int decode_eap_message(
    EAPMessage* eapmessage, uint8_t iei, uint8_t* buffer, uint32_t len);

#endif
