/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef EPSNAS_SECURITY_ALGORITHMS_H_
#define EPSNAS_SECURITY_ALGORITHMS_H_

#include <stdint.h>
#include "bstrlib.h"

#define EPSNAS_SECURITY_ALGORITHMS_MINIMUM_LENGTH 2
#define EPSNAS_SECURITY_ALGORITHMS_MAXIMUM_LENGTH 2

#define NAS_SECURITY_ALGORITHMS_EEA0 0b000
#define NAS_SECURITY_ALGORITHMS_EEA1 0b001
#define NAS_SECURITY_ALGORITHMS_EEA2 0b010
#define NAS_SECURITY_ALGORITHMS_EEA3 0b011
#define NAS_SECURITY_ALGORITHMS_EEA4 0b100
#define NAS_SECURITY_ALGORITHMS_EEA5 0b101
#define NAS_SECURITY_ALGORITHMS_EEA6 0b110
#define NAS_SECURITY_ALGORITHMS_EEA7 0b111

#define NAS_SECURITY_ALGORITHMS_EIA0 0b000
#define NAS_SECURITY_ALGORITHMS_EIA1 0b001
#define NAS_SECURITY_ALGORITHMS_EIA2 0b010
#define NAS_SECURITY_ALGORITHMS_EIA3 0b011
#define NAS_SECURITY_ALGORITHMS_EIA4 0b100
#define NAS_SECURITY_ALGORITHMS_EIA5 0b101
#define NAS_SECURITY_ALGORITHMS_EIA6 0b110
#define NAS_SECURITY_ALGORITHMS_EIA7 0b111

typedef struct {
  uint8_t typeOfCipheringAlgoithm : 3;
  uint8_t typeOfIntegrityProtectionAlgoithm : 3;
} EPSNASSecurityAlgorithms;

int encode_epsnas_security_algorithms(
    EPSNASSecurityAlgorithms epsnassecurityalgorithms, uint8_t iei,
    uint8_t* buffer, uint32_t len);
int decode_epsnas_security_algorithms(
    EPSNASSecurityAlgorithms* epsnassecurityalgorithms, uint8_t iei,
    uint8_t* buffer, uint32_t len);

#endif
