/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef _EXTENDEDPROTOCOLCONFIGURATIONOPTIONS_H_
#define _EXTENDEDPROTOCOLCONFIGURATIONOPTIONS_H_

#include <stdint.h>
#include "nas_lib.h"
#include <stdbool.h>

#define EXTENDED_PROTOCOL_CONFIGURATION_OPTIONS_MINIMUM_LENGTH 4
#define EXTENDED_PROTOCOL_CONFIGURATION_OPTIONS_MAXIMUM_LENGTH 65538

#define EXTENDED_PROTOCOL_CONFIGURATION_OPTIONS_MINIMUM_LENGTH_TLVE 4
#define EXTENDED_PROTOCOL_CONFIGURATION_OPTIONS_MAXIMUM_LENGTH_TLVE 65538

typedef protocol_configuration_options_nas_t
    ExtendedProtocolConfigurationOptions;

int encode_extended_protocol_configuration_options(
    protocol_configuration_options_nas_t extendedprotocolconfigurationoptions,
    uint8_t iei, uint8_t* buffer, uint32_t len);
int decode_extended_protocol_configuration_options(
    protocol_configuration_options_nas_t* extendedprotocolconfigurationoptions,
    uint8_t iei, uint8_t* buffer, uint32_t len);

int decode_protocol_configuration_options(
    protocol_configuration_options_nas_t* protocolconfigurationoptions,
    const uint8_t* const buffer, const uint32_t len);

int encode_protocol_configuration_options(
    const protocol_configuration_options_nas_t protocolconfigurationoptions,
    uint8_t* buffer, const uint32_t len);

#endif
