/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef IMEISV_REQUEST_H_
#define IMEISV_REQUEST_H_

#include <stdint.h>
#include "bstrlib.h"

#define IMEISV_REQUEST_MINIMUM_LENGTH 1
#define IMEISV_REQUEST_MAXIMUM_LENGTH 1

#define SECURITY_MODE_COMMAND_IMEISV_NOT_REQUESTED 0b000
#define SECURITY_MODE_COMMAND_IMEISV_REQUESTED 0b001

typedef uint8_t IMEISVRequest;

int encode_imeisv_request(
    IMEISVRequest imeisvrequest, uint8_t iei, uint8_t* buffer, uint32_t len);
int decode_imeisv_request(
    IMEISVRequest* imeisvrequest, uint8_t iei, uint8_t* buffer, uint32_t len);

#endif
