/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

#include "TLVEncoder.h"
#include "TLVDecoder.h"
#include "IntergrityProtectionMaximumDataRate.h"

int encode_intergrity_protection_maximum_data_rate(
    IntergrityProtectionMaximumDataRate intergrityprotectionmaximumdatarate,
    uint8_t iei, uint8_t* buffer, uint32_t len) {
  uint32_t encoded  = 0;
  int encode_result = 0;
  CHECK_PDU_POINTER_AND_LENGTH_ENCODER(
      buffer,
      ((iei > 0) ? INTERGRITY_PROTECTION_MAXIMUM_DATA_RATE_MINIMUM_LENGTH_TV :
                   INTERGRITY_PROTECTION_MAXIMUM_DATA_RATE_MINIMUM_LENGTH_V),
      len);

  if (iei > 0) {
    *buffer = iei;
    encoded++;
  }

  if ((encode_result = encode_bstring(
           intergrityprotectionmaximumdatarate, buffer + encoded,
           len - encoded)) < 0)
    return encode_result;
  else
    encoded += encode_result;

  return encoded;
}

int decode_intergrity_protection_maximum_data_rate(
    IntergrityProtectionMaximumDataRate* intergrityprotectionmaximumdatarate,
    uint8_t iei, uint8_t* buffer, uint32_t len) {
  int decoded       = 0;
  uint8_t ielen     = 2;
  int decode_result = 0;

  if (iei > 0) {
    CHECK_IEI_DECODER(iei, *buffer);
    decoded++;
  }

  if ((decode_result = decode_bstring(
           intergrityprotectionmaximumdatarate, ielen, buffer + decoded,
           len - decoded)) < 0)
    return decode_result;
  else
    decoded += decode_result;
  return decoded;
}
