/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef _INTERGRITYPROTECTIONMAXIMUMDATARATE_H_
#define _INTERGRITYPROTECTIONMAXIMUMDATARATE_H_

#include <stdint.h>
#include "bstrlib.h"

#define INTERGRITY_PROTECTION_MAXIMUM_DATA_RATE_MINIMUM_LENGTH 2
#define INTERGRITY_PROTECTION_MAXIMUM_DATA_RATE_MAXIMUM_LENGTH 2

#define INTERGRITY_PROTECTION_MAXIMUM_DATA_RATE_MINIMUM_LENGTH_V 2
#define INTERGRITY_PROTECTION_MAXIMUM_DATA_RATE_MAXIMUM_LENGTH_V 2
#define INTERGRITY_PROTECTION_MAXIMUM_DATA_RATE_MINIMUM_LENGTH_TV 3
#define INTERGRITY_PROTECTION_MAXIMUM_DATA_RATE_MAXIMUM_LENGTH_TV 3

typedef bstring IntergrityProtectionMaximumDataRate;

int encode_intergrity_protection_maximum_data_rate(
    IntergrityProtectionMaximumDataRate intergrityprotectionmaximumdatarate,
    uint8_t iei, uint8_t* buffer, uint32_t len);
int decode_intergrity_protection_maximum_data_rate(
    IntergrityProtectionMaximumDataRate* intergrityprotectionmaximumdatarate,
    uint8_t iei, uint8_t* buffer, uint32_t len);

#endif
