/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef _MAXIMUMNUMBEROFSUPPORTEDPACKETFILTERS_H_
#define _MAXIMUMNUMBEROFSUPPORTEDPACKETFILTERS_H_

#include <stdint.h>
#include "bstrlib.h"

#define MAXIMUM_NUMBER_OF_SUPPORTED_PACKET_FILTERS_MINIMUM_LENGTH 3
#define MAXIMUM_NUMBER_OF_SUPPORTED_PACKET_FILTERS_MAXIMUM_LENGTH 3

#define MAXIMUM_NUMBER_OF_SUPPORTED_PACKET_FILTERS_MINIMUM_LENGTH_TV 3
#define MAXIMUM_NUMBER_OF_SUPPORTED_PACKET_FILTERS_MAXIMUM_LENGTH_TV 3

typedef uint16_t MaximumNumberOfSupportedPacketFilters;

int encode_maximum_number_of_supported_packet_filters(
    MaximumNumberOfSupportedPacketFilters maximumnumberofsupportedpacketfilters,
    uint8_t iei, uint8_t* buffer, uint32_t len);
int decode_maximum_number_of_supported_packet_filters(
    MaximumNumberOfSupportedPacketFilters*
        maximumnumberofsupportedpacketfilters,
    uint8_t iei, uint8_t* buffer, uint32_t len);

#endif
