/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

#include "TLVEncoder.h"
#include "TLVDecoder.h"
#include "NASSecurityAlgorithms.h"

int encode_nas_security_algorithms(
    NASSecurityAlgorithms nassecurityalgorithms, uint8_t iei, uint8_t* buffer,
    uint32_t len) {
  uint8_t encoded           = 0;
  uint8_t selectedAlgorithm = 0x0;
  CHECK_PDU_POINTER_AND_LENGTH_ENCODER(
      buffer, NAS_SECURITY_ALGORITHMS_MINIMUM_LENGTH, len);

  if (iei > 0) {
    *buffer = iei;
    encoded++;
  }

  selectedAlgorithm =
      (nassecurityalgorithms.typeOfCipheringAlgorithm << 4) |
      (nassecurityalgorithms.typeOfIntegrityProtectionAlgorithm);
  ENCODE_U8(buffer + encoded, selectedAlgorithm, encoded);

  return encoded;
}

int decode_nas_security_algorithms(
    NASSecurityAlgorithms* nassecurityalgorithms, uint8_t iei, uint8_t* buffer,
    uint32_t len) {
  int decoded               = 0;
  uint8_t selectedAlgorithm = 0x0;

  if (iei > 0) {
    CHECK_IEI_DECODER(iei, *buffer);
    decoded++;
  }

  DECODE_U8(buffer + decoded, selectedAlgorithm, decoded);
  nassecurityalgorithms->typeOfCipheringAlgorithm =
      ((selectedAlgorithm & 0xf0) >> 4);
  nassecurityalgorithms->typeOfIntegrityProtectionAlgorithm =
      (selectedAlgorithm & 0x0f);

  return decoded;
}
