/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef NAS_SECURITY_ALGORITHMS_H_
#define NAS_SECURITY_ALGORITHMS_H_

#include <stdint.h>
#include "bstrlib.h"

#define NAS_SECURITY_ALGORITHMS_MINIMUM_LENGTH 2
#define NAS_SECURITY_ALGORITHMS_MAXIMUM_LENGTH 2

#define NAS_SECURITY_ALGORITHMS_NEA0 0b0000
#define NAS_SECURITY_ALGORITHMS_NEA1 0b0001
#define NAS_SECURITY_ALGORITHMS_NEA2 0b0010
#define NAS_SECURITY_ALGORITHMS_NEA3 0b0011
#define NAS_SECURITY_ALGORITHMS_NEA4 0b0100
#define NAS_SECURITY_ALGORITHMS_NEA5 0b0101
#define NAS_SECURITY_ALGORITHMS_NEA6 0b0110
#define NAS_SECURITY_ALGORITHMS_NEA7 0b0111

#define NAS_SECURITY_ALGORITHMS_NIA0 0b0000
#define NAS_SECURITY_ALGORITHMS_NIA1 0b0001
#define NAS_SECURITY_ALGORITHMS_NIA2 0b0010
#define NAS_SECURITY_ALGORITHMS_NIA3 0b0011
#define NAS_SECURITY_ALGORITHMS_NIA4 0b0100
#define NAS_SECURITY_ALGORITHMS_NIA5 0b0101
#define NAS_SECURITY_ALGORITHMS_NIA6 0b0110
#define NAS_SECURITY_ALGORITHMS_NIA7 0b0111

typedef struct {
  uint8_t typeOfCipheringAlgorithm : 4;
  uint8_t typeOfIntegrityProtectionAlgorithm : 4;
} NASSecurityAlgorithms;

int encode_nas_security_algorithms(
    NASSecurityAlgorithms nassecurityalgorithms, uint8_t iei, uint8_t* buffer,
    uint32_t len);
int decode_nas_security_algorithms(
    NASSecurityAlgorithms* nassecurityalgorithms, uint8_t iei, uint8_t* buffer,
    uint32_t len);

#endif
