/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef NSSAI_INCLUSION_MODE_H_
#define NSSAI_INCLUSION_MODE_H_

#include <stdint.h>
#include "bstrlib.h"

#define NSSAI_INCLUSION_MODE_MINIMUM_LENGTH 1
#define NSSAI_INCLUSION_MODE_MAXIMUM_LENGTH 1

#define NSSAI_INCLUSION_MODE_A 0b00
#define NSSAI_INCLUSION_MODE_B 0b01
#define NSSAI_INCLUSION_MODE_C 0b10
#define NSSAI_INCLUSION_MODE_D 0b11

typedef uint8_t NSSAIInclusionMode;

int encode_nssai_inclusion_mode(
    NSSAIInclusionMode nssaiinclusionmode, uint8_t iei, uint8_t* buffer,
    uint32_t len);
int decode_nssai_inclusion_mode(
    NSSAIInclusionMode* nssaiinclusionmode, uint8_t iei, uint8_t* buffer,
    uint32_t len);

#endif
