/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#include <stdint.h>
#include "bstrlib.h"

#define OPERATOR_DEFINED_ACCESS_CATEGORY_DEFINITIONS_MINIMUM_LENGTH 3
#define OPERATOR_DEFINED_ACCESS_CATEGORY_DEFINITIONS_MAXIMUM_LENGTH 9999

typedef bstring OperatorDefinedAccessCategoryDefinitions;

int encode_operator_defined_access_category_definitions(
    OperatorDefinedAccessCategoryDefinitions
        operatordefinedaccesscategorydefinitions,
    uint8_t iei, uint8_t* buffer, uint32_t len);
int decode_operator_defined_access_category_definitions(
    OperatorDefinedAccessCategoryDefinitions*
        operatordefinedaccesscategorydefinitions,
    uint8_t iei, uint8_t* buffer, uint32_t len);
