/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#include <stdint.h>
#include "bstrlib.h"

#define PDU_ADDRESS_MINIMUM_LENGTH 7
#define PDU_ADDRESS_MAXIMUM_LENGTH 15

#define PDU_ADDRESS_MINIMUM_LENGTH_TLV 7
#define PDU_ADDRESS_MAXIMUM_LENGTH_TLV 15

#define PDU_ADDRESS_IPV4 0x01
#define PDU_ADDRESS_IPV6 0x02
#define PDU_ADDRESS_IPV4V6 0x03

typedef struct {
  uint8_t length;
  uint8_t spare : 5;
  uint8_t pdu_session_type_value : 3;
  bstring pdu_address_information;
} __attribute__((__packed__)) PDUAddress;

int encode_pdu_address(
    PDUAddress pduaddress, uint8_t iei, uint8_t* buffer, uint32_t len);
int decode_pdu_address(
    PDUAddress* pduaddress, uint8_t iei, uint8_t* buffer, uint32_t len);
