/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef _PDU_SESSION_REACTIVATION_RESULT_ERROR_CAUSE_H_
#define _PDU_SESSION_REACTIVATION_RESULT_ERROR_CAUSE_H_

#include <stdint.h>
#include "bstrlib.h"

#define PDU_SESSION_REACTIVATION_RESULT_ERROR_CAUSE_MINIMUM_LENGTH 5
#define PDU_SESSION_REACTIVATION_RESULT_ERROR_CAUSE_MAXIMUM_LENGTH 515

struct PduSessionID_CauseValue {
  uint8_t pduSessionID;
  uint8_t causeValue;
  struct PduSessionID_CauseValue* next;
};

typedef struct {
  uint16_t size;
  struct PduSessionID_CauseValue* element;
} PDUSessionReactivationResultErrorCause;

int encode_pdu_session_reactivation_result_error_cause(
    PDUSessionReactivationResultErrorCause
        pdusessionreactivationresulterrorcause,
    uint8_t iei, uint8_t* buffer, uint32_t len);
int decode_pdu_session_reactivation_result_error_cause(
    PDUSessionReactivationResultErrorCause*
        pdusessionreactivationresulterrorcause,
    uint8_t iei, uint8_t* buffer, uint32_t len);
#endif
