/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#include <stdint.h>
#include "bstrlib.h"

#define PLMN_LIST_MINIMUM_LENGTH 5
#define PLMN_LIST_MAXIMUM_LENGTH 47

typedef struct {
  uint16_t mcc;
  uint16_t mnc;
} PLMN;
typedef PLMN PLMNList[15];

int encode_plmn_list(
    PLMNList plmnlist, uint8_t iei, uint8_t* buffer, uint32_t len);
int decode_plmn_list(
    PLMNList plmnlist, uint8_t iei, uint8_t* buffer, uint32_t len);
