/*
 * Licensed to Open Source Radio Access Network(OS-RAN) Alliance and OAI
 * Software Alliance under one or more contributor license agreements. The
 * initial OpenXG series projects are derided from OAI projects, the files from
 * OAI projects are all in compliance with OAI Public License, Version 1.1.
 * codes and files developed from OpenXG projects and from OS-RAN Alliance
 * are all under OS-RAN licenses; you may not use this file except in compliance
 * with the license.  You may get a copy of the license at:
 *	http://www.openxg.org.cn/?falu_69.html
 * For more information about OpenXG, please contact:
 * contact@openxg.org.cn
 */

#ifndef _SNSSAI_H_
#define _SNSSAI_H_

#include <stdint.h>
#include "bstrlib.h"

#define SNSSAI_MINIMUM_LENGTH 3
#define SNSSAI_MAXIMUM_LENGTH 10

#define SNSSAI_MINIMUM_LENGTH_TLV 3
#define SNSSAI_MAXIMUM_LENGTH_TLV 10

typedef enum {
  SST_LENGTH                                             = 0b00000001,
  SST_AND_MAPPEDHPLMNSST_LENGTH                          = 0b00000010,
  SST_AND_SD_LENGTH                                      = 0b00000100,
  SST_AND_SD_AND_MAPPEDHPLMNSST_LENGTH                   = 0b00000101,
  SST_AND_SD_AND_MAPPEDHPLMNSST_AND_MAPPEDHPLMNSD_LENGTH = 0b00001000
} length_of_snssai_contents;

typedef struct {
  length_of_snssai_contents len;
  uint8_t sst;
  uint32_t sd : 24;
  uint8_t mappedhplmnsst;
  uint32_t mappedhplmnsd;
} SNSSAI;

int encode_snssai(SNSSAI snssai, uint8_t iei, uint8_t* buffer, uint32_t len);
int decode_snssai(SNSSAI* snssai, uint8_t iei, uint8_t* buffer, uint32_t len);

#endif
